// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The parameters to provide for the Alexa channel. */
@Fluent
public final class AlexaChannelProperties {
    /*
     * The Alexa skill Id
     */
    @JsonProperty(value = "alexaSkillId", required = true)
    private String alexaSkillId;

    /*
     * Url fragment used in part of the Uri configured in Alexa
     */
    @JsonProperty(value = "urlFragment", access = JsonProperty.Access.WRITE_ONLY)
    private String urlFragment;

    /*
     * Full Uri used to configured the skill in Alexa
     */
    @JsonProperty(value = "serviceEndpointUri", access = JsonProperty.Access.WRITE_ONLY)
    private String serviceEndpointUri;

    /*
     * Whether this channel is enabled for the bot
     */
    @JsonProperty(value = "isEnabled", required = true)
    private boolean isEnabled;

    /**
     * Get the alexaSkillId property: The Alexa skill Id.
     *
     * @return the alexaSkillId value.
     */
    public String alexaSkillId() {
        return this.alexaSkillId;
    }

    /**
     * Set the alexaSkillId property: The Alexa skill Id.
     *
     * @param alexaSkillId the alexaSkillId value to set.
     * @return the AlexaChannelProperties object itself.
     */
    public AlexaChannelProperties withAlexaSkillId(String alexaSkillId) {
        this.alexaSkillId = alexaSkillId;
        return this;
    }

    /**
     * Get the urlFragment property: Url fragment used in part of the Uri configured in Alexa.
     *
     * @return the urlFragment value.
     */
    public String urlFragment() {
        return this.urlFragment;
    }

    /**
     * Get the serviceEndpointUri property: Full Uri used to configured the skill in Alexa.
     *
     * @return the serviceEndpointUri value.
     */
    public String serviceEndpointUri() {
        return this.serviceEndpointUri;
    }

    /**
     * Get the isEnabled property: Whether this channel is enabled for the bot.
     *
     * @return the isEnabled value.
     */
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Whether this channel is enabled for the bot.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the AlexaChannelProperties object itself.
     */
    public AlexaChannelProperties withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (alexaSkillId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property alexaSkillId in model AlexaChannelProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AlexaChannelProperties.class);
}
