// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/** Resource collection API of BotConnections. */
public interface BotConnections {
    /**
     * Lists the available Service Providers for creating Connection Settings.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of bot service providers response.
     */
    ServiceProviderResponseList listServiceProviders();

    /**
     * Lists the available Service Providers for creating Connection Settings.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of bot service providers response along with {@link Response}.
     */
    Response<ServiceProviderResponseList> listServiceProvidersWithResponse(Context context);

    /**
     * Get a Connection Setting registration for a Bot Service.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Connection Setting registration for a Bot Service.
     */
    ConnectionSetting listWithSecrets(String resourceGroupName, String resourceName, String connectionName);

    /**
     * Get a Connection Setting registration for a Bot Service.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Connection Setting registration for a Bot Service along with {@link Response}.
     */
    Response<ConnectionSetting> listWithSecretsWithResponse(
        String resourceGroupName, String resourceName, String connectionName, Context context);

    /**
     * Get a Connection Setting registration for a Bot Service.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Connection Setting registration for a Bot Service.
     */
    ConnectionSetting get(String resourceGroupName, String resourceName, String connectionName);

    /**
     * Get a Connection Setting registration for a Bot Service.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Connection Setting registration for a Bot Service along with {@link Response}.
     */
    Response<ConnectionSetting> getWithResponse(
        String resourceGroupName, String resourceName, String connectionName, Context context);

    /**
     * Deletes a Connection Setting registration for a Bot Service.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String resourceName, String connectionName);

    /**
     * Deletes a Connection Setting registration for a Bot Service.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(
        String resourceGroupName, String resourceName, String connectionName, Context context);

    /**
     * Returns all the Connection Settings registered to a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of bot service connection settings response as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ConnectionSetting> listByBotService(String resourceGroupName, String resourceName);

    /**
     * Returns all the Connection Settings registered to a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of bot service connection settings response as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ConnectionSetting> listByBotService(String resourceGroupName, String resourceName, Context context);

    /**
     * Get a Connection Setting registration for a Bot Service.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Connection Setting registration for a Bot Service along with {@link Response}.
     */
    ConnectionSetting getById(String id);

    /**
     * Get a Connection Setting registration for a Bot Service.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Connection Setting registration for a Bot Service along with {@link Response}.
     */
    Response<ConnectionSetting> getByIdWithResponse(String id, Context context);

    /**
     * Deletes a Connection Setting registration for a Bot Service.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes a Connection Setting registration for a Bot Service.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new ConnectionSetting resource.
     *
     * @param name resource name.
     * @return the first stage of the new ConnectionSetting definition.
     */
    ConnectionSetting.DefinitionStages.Blank define(String name);
}
