// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.fluent.models.PrivateEndpointConnectionInner;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The parameters to provide for the Bot. */
@Fluent
public final class BotProperties {
    /*
     * The Name of the bot
     */
    @JsonProperty(value = "displayName", required = true)
    private String displayName;

    /*
     * The description of the bot
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The Icon Url of the bot
     */
    @JsonProperty(value = "iconUrl")
    private String iconUrl;

    /*
     * The bot's endpoint
     */
    @JsonProperty(value = "endpoint", required = true)
    private String endpoint;

    /*
     * The bot's endpoint version
     */
    @JsonProperty(value = "endpointVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String endpointVersion;

    /*
     * Contains resource all settings defined as key/value pairs.
     */
    @JsonProperty(value = "allSettings")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> allSettings;

    /*
     * Contains resource parameters defined as key/value pairs.
     */
    @JsonProperty(value = "parameters")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> parameters;

    /*
     * The bot's manifest url
     */
    @JsonProperty(value = "manifestUrl")
    private String manifestUrl;

    /*
     * Microsoft App Type for the bot
     */
    @JsonProperty(value = "msaAppType")
    private MsaAppType msaAppType;

    /*
     * Microsoft App Id for the bot
     */
    @JsonProperty(value = "msaAppId", required = true)
    private String msaAppId;

    /*
     * Microsoft App Tenant Id for the bot
     */
    @JsonProperty(value = "msaAppTenantId")
    private String msaAppTenantId;

    /*
     * Microsoft App Managed Identity Resource Id for the bot
     */
    @JsonProperty(value = "msaAppMSIResourceId")
    private String msaAppMsiResourceId;

    /*
     * Collection of channels for which the bot is configured
     */
    @JsonProperty(value = "configuredChannels", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> configuredChannels;

    /*
     * Collection of channels for which the bot is enabled
     */
    @JsonProperty(value = "enabledChannels", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> enabledChannels;

    /*
     * The Application Insights key
     */
    @JsonProperty(value = "developerAppInsightKey")
    private String developerAppInsightKey;

    /*
     * The Application Insights Api Key
     */
    @JsonProperty(value = "developerAppInsightsApiKey")
    private String developerAppInsightsApiKey;

    /*
     * The Application Insights App Id
     */
    @JsonProperty(value = "developerAppInsightsApplicationId")
    private String developerAppInsightsApplicationId;

    /*
     * Collection of LUIS App Ids
     */
    @JsonProperty(value = "luisAppIds")
    private List<String> luisAppIds;

    /*
     * The LUIS Key
     */
    @JsonProperty(value = "luisKey")
    private String luisKey;

    /*
     * Whether Cmek is enabled
     */
    @JsonProperty(value = "isCmekEnabled")
    private Boolean isCmekEnabled;

    /*
     * The CMK Url
     */
    @JsonProperty(value = "cmekKeyVaultUrl")
    private String cmekKeyVaultUrl;

    /*
     * The CMK encryption status
     */
    @JsonProperty(value = "cmekEncryptionStatus", access = JsonProperty.Access.WRITE_ONLY)
    private String cmekEncryptionStatus;

    /*
     * Whether the bot is in an isolated network
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Whether the bot is streaming supported
     */
    @JsonProperty(value = "isStreamingSupported")
    private Boolean isStreamingSupported;

    /*
     * Whether the bot is developerAppInsightsApiKey set
     */
    @JsonProperty(value = "isDeveloperAppInsightsApiKeySet", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isDeveloperAppInsightsApiKeySet;

    /*
     * Token used to migrate non Azure bot to azure subscription
     */
    @JsonProperty(value = "migrationToken", access = JsonProperty.Access.WRITE_ONLY)
    private String migrationToken;

    /*
     * Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     */
    @JsonProperty(value = "disableLocalAuth")
    private Boolean disableLocalAuth;

    /*
     * The channel schema transformation version for the bot
     */
    @JsonProperty(value = "schemaTransformationVersion")
    private String schemaTransformationVersion;

    /*
     * The storage resourceId for the bot
     */
    @JsonProperty(value = "storageResourceId")
    private String storageResourceId;

    /*
     * List of Private Endpoint Connections configured for the bot
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * The hint to browser (e.g. protocol handler) on how to open the bot for
     * authoring
     */
    @JsonProperty(value = "openWithHint")
    private String openWithHint;

    /*
     * The hint (e.g. keyVault secret resourceId) on how to fetch the app
     * secret
     */
    @JsonProperty(value = "appPasswordHint")
    private String appPasswordHint;

    /*
     * Provisioning state of the resource
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * Publishing credentials of the resource
     */
    @JsonProperty(value = "publishingCredentials")
    private String publishingCredentials;

    /**
     * Get the displayName property: The Name of the bot.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The Name of the bot.
     *
     * @param displayName the displayName value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description of the bot.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the bot.
     *
     * @param description the description value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the iconUrl property: The Icon Url of the bot.
     *
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.iconUrl;
    }

    /**
     * Set the iconUrl property: The Icon Url of the bot.
     *
     * @param iconUrl the iconUrl value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    /**
     * Get the endpoint property: The bot's endpoint.
     *
     * @return the endpoint value.
     */
    public String endpoint() {
        return this.endpoint;
    }

    /**
     * Set the endpoint property: The bot's endpoint.
     *
     * @param endpoint the endpoint value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    /**
     * Get the endpointVersion property: The bot's endpoint version.
     *
     * @return the endpointVersion value.
     */
    public String endpointVersion() {
        return this.endpointVersion;
    }

    /**
     * Get the allSettings property: Contains resource all settings defined as key/value pairs.
     *
     * @return the allSettings value.
     */
    public Map<String, String> allSettings() {
        return this.allSettings;
    }

    /**
     * Set the allSettings property: Contains resource all settings defined as key/value pairs.
     *
     * @param allSettings the allSettings value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withAllSettings(Map<String, String> allSettings) {
        this.allSettings = allSettings;
        return this;
    }

    /**
     * Get the parameters property: Contains resource parameters defined as key/value pairs.
     *
     * @return the parameters value.
     */
    public Map<String, String> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Contains resource parameters defined as key/value pairs.
     *
     * @param parameters the parameters value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the manifestUrl property: The bot's manifest url.
     *
     * @return the manifestUrl value.
     */
    public String manifestUrl() {
        return this.manifestUrl;
    }

    /**
     * Set the manifestUrl property: The bot's manifest url.
     *
     * @param manifestUrl the manifestUrl value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
        return this;
    }

    /**
     * Get the msaAppType property: Microsoft App Type for the bot.
     *
     * @return the msaAppType value.
     */
    public MsaAppType msaAppType() {
        return this.msaAppType;
    }

    /**
     * Set the msaAppType property: Microsoft App Type for the bot.
     *
     * @param msaAppType the msaAppType value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withMsaAppType(MsaAppType msaAppType) {
        this.msaAppType = msaAppType;
        return this;
    }

    /**
     * Get the msaAppId property: Microsoft App Id for the bot.
     *
     * @return the msaAppId value.
     */
    public String msaAppId() {
        return this.msaAppId;
    }

    /**
     * Set the msaAppId property: Microsoft App Id for the bot.
     *
     * @param msaAppId the msaAppId value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withMsaAppId(String msaAppId) {
        this.msaAppId = msaAppId;
        return this;
    }

    /**
     * Get the msaAppTenantId property: Microsoft App Tenant Id for the bot.
     *
     * @return the msaAppTenantId value.
     */
    public String msaAppTenantId() {
        return this.msaAppTenantId;
    }

    /**
     * Set the msaAppTenantId property: Microsoft App Tenant Id for the bot.
     *
     * @param msaAppTenantId the msaAppTenantId value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withMsaAppTenantId(String msaAppTenantId) {
        this.msaAppTenantId = msaAppTenantId;
        return this;
    }

    /**
     * Get the msaAppMsiResourceId property: Microsoft App Managed Identity Resource Id for the bot.
     *
     * @return the msaAppMsiResourceId value.
     */
    public String msaAppMsiResourceId() {
        return this.msaAppMsiResourceId;
    }

    /**
     * Set the msaAppMsiResourceId property: Microsoft App Managed Identity Resource Id for the bot.
     *
     * @param msaAppMsiResourceId the msaAppMsiResourceId value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withMsaAppMsiResourceId(String msaAppMsiResourceId) {
        this.msaAppMsiResourceId = msaAppMsiResourceId;
        return this;
    }

    /**
     * Get the configuredChannels property: Collection of channels for which the bot is configured.
     *
     * @return the configuredChannels value.
     */
    public List<String> configuredChannels() {
        return this.configuredChannels;
    }

    /**
     * Get the enabledChannels property: Collection of channels for which the bot is enabled.
     *
     * @return the enabledChannels value.
     */
    public List<String> enabledChannels() {
        return this.enabledChannels;
    }

    /**
     * Get the developerAppInsightKey property: The Application Insights key.
     *
     * @return the developerAppInsightKey value.
     */
    public String developerAppInsightKey() {
        return this.developerAppInsightKey;
    }

    /**
     * Set the developerAppInsightKey property: The Application Insights key.
     *
     * @param developerAppInsightKey the developerAppInsightKey value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withDeveloperAppInsightKey(String developerAppInsightKey) {
        this.developerAppInsightKey = developerAppInsightKey;
        return this;
    }

    /**
     * Get the developerAppInsightsApiKey property: The Application Insights Api Key.
     *
     * @return the developerAppInsightsApiKey value.
     */
    public String developerAppInsightsApiKey() {
        return this.developerAppInsightsApiKey;
    }

    /**
     * Set the developerAppInsightsApiKey property: The Application Insights Api Key.
     *
     * @param developerAppInsightsApiKey the developerAppInsightsApiKey value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withDeveloperAppInsightsApiKey(String developerAppInsightsApiKey) {
        this.developerAppInsightsApiKey = developerAppInsightsApiKey;
        return this;
    }

    /**
     * Get the developerAppInsightsApplicationId property: The Application Insights App Id.
     *
     * @return the developerAppInsightsApplicationId value.
     */
    public String developerAppInsightsApplicationId() {
        return this.developerAppInsightsApplicationId;
    }

    /**
     * Set the developerAppInsightsApplicationId property: The Application Insights App Id.
     *
     * @param developerAppInsightsApplicationId the developerAppInsightsApplicationId value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withDeveloperAppInsightsApplicationId(String developerAppInsightsApplicationId) {
        this.developerAppInsightsApplicationId = developerAppInsightsApplicationId;
        return this;
    }

    /**
     * Get the luisAppIds property: Collection of LUIS App Ids.
     *
     * @return the luisAppIds value.
     */
    public List<String> luisAppIds() {
        return this.luisAppIds;
    }

    /**
     * Set the luisAppIds property: Collection of LUIS App Ids.
     *
     * @param luisAppIds the luisAppIds value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withLuisAppIds(List<String> luisAppIds) {
        this.luisAppIds = luisAppIds;
        return this;
    }

    /**
     * Get the luisKey property: The LUIS Key.
     *
     * @return the luisKey value.
     */
    public String luisKey() {
        return this.luisKey;
    }

    /**
     * Set the luisKey property: The LUIS Key.
     *
     * @param luisKey the luisKey value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withLuisKey(String luisKey) {
        this.luisKey = luisKey;
        return this;
    }

    /**
     * Get the isCmekEnabled property: Whether Cmek is enabled.
     *
     * @return the isCmekEnabled value.
     */
    public Boolean isCmekEnabled() {
        return this.isCmekEnabled;
    }

    /**
     * Set the isCmekEnabled property: Whether Cmek is enabled.
     *
     * @param isCmekEnabled the isCmekEnabled value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withIsCmekEnabled(Boolean isCmekEnabled) {
        this.isCmekEnabled = isCmekEnabled;
        return this;
    }

    /**
     * Get the cmekKeyVaultUrl property: The CMK Url.
     *
     * @return the cmekKeyVaultUrl value.
     */
    public String cmekKeyVaultUrl() {
        return this.cmekKeyVaultUrl;
    }

    /**
     * Set the cmekKeyVaultUrl property: The CMK Url.
     *
     * @param cmekKeyVaultUrl the cmekKeyVaultUrl value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withCmekKeyVaultUrl(String cmekKeyVaultUrl) {
        this.cmekKeyVaultUrl = cmekKeyVaultUrl;
        return this;
    }

    /**
     * Get the cmekEncryptionStatus property: The CMK encryption status.
     *
     * @return the cmekEncryptionStatus value.
     */
    public String cmekEncryptionStatus() {
        return this.cmekEncryptionStatus;
    }

    /**
     * Get the publicNetworkAccess property: Whether the bot is in an isolated network.
     *
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether the bot is in an isolated network.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the isStreamingSupported property: Whether the bot is streaming supported.
     *
     * @return the isStreamingSupported value.
     */
    public Boolean isStreamingSupported() {
        return this.isStreamingSupported;
    }

    /**
     * Set the isStreamingSupported property: Whether the bot is streaming supported.
     *
     * @param isStreamingSupported the isStreamingSupported value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withIsStreamingSupported(Boolean isStreamingSupported) {
        this.isStreamingSupported = isStreamingSupported;
        return this;
    }

    /**
     * Get the isDeveloperAppInsightsApiKeySet property: Whether the bot is developerAppInsightsApiKey set.
     *
     * @return the isDeveloperAppInsightsApiKeySet value.
     */
    public Boolean isDeveloperAppInsightsApiKeySet() {
        return this.isDeveloperAppInsightsApiKeySet;
    }

    /**
     * Get the migrationToken property: Token used to migrate non Azure bot to azure subscription.
     *
     * @return the migrationToken value.
     */
    public String migrationToken() {
        return this.migrationToken;
    }

    /**
     * Get the disableLocalAuth property: Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     *
     * @return the disableLocalAuth value.
     */
    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    /**
     * Set the disableLocalAuth property: Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     *
     * @param disableLocalAuth the disableLocalAuth value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    /**
     * Get the schemaTransformationVersion property: The channel schema transformation version for the bot.
     *
     * @return the schemaTransformationVersion value.
     */
    public String schemaTransformationVersion() {
        return this.schemaTransformationVersion;
    }

    /**
     * Set the schemaTransformationVersion property: The channel schema transformation version for the bot.
     *
     * @param schemaTransformationVersion the schemaTransformationVersion value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withSchemaTransformationVersion(String schemaTransformationVersion) {
        this.schemaTransformationVersion = schemaTransformationVersion;
        return this;
    }

    /**
     * Get the storageResourceId property: The storage resourceId for the bot.
     *
     * @return the storageResourceId value.
     */
    public String storageResourceId() {
        return this.storageResourceId;
    }

    /**
     * Set the storageResourceId property: The storage resourceId for the bot.
     *
     * @param storageResourceId the storageResourceId value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of Private Endpoint Connections configured for the bot.
     *
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the openWithHint property: The hint to browser (e.g. protocol handler) on how to open the bot for authoring.
     *
     * @return the openWithHint value.
     */
    public String openWithHint() {
        return this.openWithHint;
    }

    /**
     * Set the openWithHint property: The hint to browser (e.g. protocol handler) on how to open the bot for authoring.
     *
     * @param openWithHint the openWithHint value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withOpenWithHint(String openWithHint) {
        this.openWithHint = openWithHint;
        return this;
    }

    /**
     * Get the appPasswordHint property: The hint (e.g. keyVault secret resourceId) on how to fetch the app secret.
     *
     * @return the appPasswordHint value.
     */
    public String appPasswordHint() {
        return this.appPasswordHint;
    }

    /**
     * Set the appPasswordHint property: The hint (e.g. keyVault secret resourceId) on how to fetch the app secret.
     *
     * @param appPasswordHint the appPasswordHint value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withAppPasswordHint(String appPasswordHint) {
        this.appPasswordHint = appPasswordHint;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the publishingCredentials property: Publishing credentials of the resource.
     *
     * @return the publishingCredentials value.
     */
    public String publishingCredentials() {
        return this.publishingCredentials;
    }

    /**
     * Set the publishingCredentials property: Publishing credentials of the resource.
     *
     * @param publishingCredentials the publishingCredentials value to set.
     * @return the BotProperties object itself.
     */
    public BotProperties withPublishingCredentials(String publishingCredentials) {
        this.publishingCredentials = publishingCredentials;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (displayName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property displayName in model BotProperties"));
        }
        if (endpoint() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property endpoint in model BotProperties"));
        }
        if (msaAppId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property msaAppId in model BotProperties"));
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BotProperties.class);
}
