// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Extra Parameter in a Connection Setting Properties to indicate service provider specific properties. */
@Fluent
public final class ConnectionSettingParameter {
    /*
     * Key for the Connection Setting Parameter.
     */
    @JsonProperty(value = "key")
    private String key;

    /*
     * Value associated with the Connection Setting Parameter.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the key property: Key for the Connection Setting Parameter.
     *
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: Key for the Connection Setting Parameter.
     *
     * @param key the key value to set.
     * @return the ConnectionSettingParameter object itself.
     */
    public ConnectionSettingParameter withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the value property: Value associated with the Connection Setting Parameter.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value associated with the Connection Setting Parameter.
     *
     * @param value the value value to set.
     * @return the ConnectionSettingParameter object itself.
     */
    public ConnectionSettingParameter withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
