// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties for a Connection Setting Item. */
@Fluent
public final class ConnectionSettingProperties {
    /*
     * Id associated with the Connection Setting.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * Name associated with the Connection Setting.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Client Id associated with the Connection Setting.
     */
    @JsonProperty(value = "clientId")
    private String clientId;

    /*
     * Setting Id set by the service for the Connection Setting.
     */
    @JsonProperty(value = "settingId", access = JsonProperty.Access.WRITE_ONLY)
    private String settingId;

    /*
     * Client Secret associated with the Connection Setting
     */
    @JsonProperty(value = "clientSecret")
    private String clientSecret;

    /*
     * Scopes associated with the Connection Setting
     */
    @JsonProperty(value = "scopes")
    private String scopes;

    /*
     * Service Provider Id associated with the Connection Setting
     */
    @JsonProperty(value = "serviceProviderId")
    private String serviceProviderId;

    /*
     * Service Provider Display Name associated with the Connection Setting
     */
    @JsonProperty(value = "serviceProviderDisplayName")
    private String serviceProviderDisplayName;

    /*
     * Service Provider Parameters associated with the Connection Setting
     */
    @JsonProperty(value = "parameters")
    private List<ConnectionSettingParameter> parameters;

    /*
     * Provisioning state of the resource
     */
    @JsonProperty(value = "provisioningState")
    private String provisioningState;

    /**
     * Get the id property: Id associated with the Connection Setting.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Id associated with the Connection Setting.
     *
     * @param id the id value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Name associated with the Connection Setting.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name associated with the Connection Setting.
     *
     * @param name the name value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the clientId property: Client Id associated with the Connection Setting.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: Client Id associated with the Connection Setting.
     *
     * @param clientId the clientId value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the settingId property: Setting Id set by the service for the Connection Setting.
     *
     * @return the settingId value.
     */
    public String settingId() {
        return this.settingId;
    }

    /**
     * Get the clientSecret property: Client Secret associated with the Connection Setting.
     *
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: Client Secret associated with the Connection Setting.
     *
     * @param clientSecret the clientSecret value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the scopes property: Scopes associated with the Connection Setting.
     *
     * @return the scopes value.
     */
    public String scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: Scopes associated with the Connection Setting.
     *
     * @param scopes the scopes value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withScopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the serviceProviderId property: Service Provider Id associated with the Connection Setting.
     *
     * @return the serviceProviderId value.
     */
    public String serviceProviderId() {
        return this.serviceProviderId;
    }

    /**
     * Set the serviceProviderId property: Service Provider Id associated with the Connection Setting.
     *
     * @param serviceProviderId the serviceProviderId value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withServiceProviderId(String serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
        return this;
    }

    /**
     * Get the serviceProviderDisplayName property: Service Provider Display Name associated with the Connection
     * Setting.
     *
     * @return the serviceProviderDisplayName value.
     */
    public String serviceProviderDisplayName() {
        return this.serviceProviderDisplayName;
    }

    /**
     * Set the serviceProviderDisplayName property: Service Provider Display Name associated with the Connection
     * Setting.
     *
     * @param serviceProviderDisplayName the serviceProviderDisplayName value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withServiceProviderDisplayName(String serviceProviderDisplayName) {
        this.serviceProviderDisplayName = serviceProviderDisplayName;
        return this;
    }

    /**
     * Get the parameters property: Service Provider Parameters associated with the Connection Setting.
     *
     * @return the parameters value.
     */
    public List<ConnectionSettingParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Service Provider Parameters associated with the Connection Setting.
     *
     * @param parameters the parameters value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withParameters(List<ConnectionSettingParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning state of the resource.
     *
     * @param provisioningState the provisioningState value to set.
     * @return the ConnectionSettingProperties object itself.
     */
    public ConnectionSettingProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }
}
