// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The parameters to provide for the Direct Line channel. */
@Fluent
public final class DirectLineChannelProperties {
    /*
     * The list of Direct Line sites
     */
    @JsonProperty(value = "sites")
    private List<DirectLineSite> sites;

    /*
     * Direct Line embed code of the resource
     */
    @JsonProperty(value = "DirectLineEmbedCode")
    private String directLineEmbedCode;

    /**
     * Get the sites property: The list of Direct Line sites.
     *
     * @return the sites value.
     */
    public List<DirectLineSite> sites() {
        return this.sites;
    }

    /**
     * Set the sites property: The list of Direct Line sites.
     *
     * @param sites the sites value to set.
     * @return the DirectLineChannelProperties object itself.
     */
    public DirectLineChannelProperties withSites(List<DirectLineSite> sites) {
        this.sites = sites;
        return this;
    }

    /**
     * Get the directLineEmbedCode property: Direct Line embed code of the resource.
     *
     * @return the directLineEmbedCode value.
     */
    public String directLineEmbedCode() {
        return this.directLineEmbedCode;
    }

    /**
     * Set the directLineEmbedCode property: Direct Line embed code of the resource.
     *
     * @param directLineEmbedCode the directLineEmbedCode value to set.
     * @return the DirectLineChannelProperties object itself.
     */
    public DirectLineChannelProperties withDirectLineEmbedCode(String directLineEmbedCode) {
        this.directLineEmbedCode = directLineEmbedCode;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sites() != null) {
            sites().forEach(e -> e.validate());
        }
    }
}
