// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The parameters to provide for the Email channel. */
@Fluent
public final class EmailChannelProperties {
    /*
     * The email address
     */
    @JsonProperty(value = "emailAddress", required = true)
    private String emailAddress;

    /*
     * The password for the email address. Value only returned through POST to
     * the action Channel List API, otherwise empty.
     */
    @JsonProperty(value = "password")
    private String password;

    /*
     * Whether this channel is enabled for the bot
     */
    @JsonProperty(value = "isEnabled", required = true)
    private boolean isEnabled;

    /**
     * Get the emailAddress property: The email address.
     *
     * @return the emailAddress value.
     */
    public String emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: The email address.
     *
     * @param emailAddress the emailAddress value to set.
     * @return the EmailChannelProperties object itself.
     */
    public EmailChannelProperties withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the password property: The password for the email address. Value only returned through POST to the action
     * Channel List API, otherwise empty.
     *
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password for the email address. Value only returned through POST to the action
     * Channel List API, otherwise empty.
     *
     * @param password the password value to set.
     * @return the EmailChannelProperties object itself.
     */
    public EmailChannelProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the isEnabled property: Whether this channel is enabled for the bot.
     *
     * @return the isEnabled value.
     */
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Whether this channel is enabled for the bot.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the EmailChannelProperties object itself.
     */
    public EmailChannelProperties withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (emailAddress() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property emailAddress in model EmailChannelProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EmailChannelProperties.class);
}
