// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** Facebook channel definition. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "channelName")
@JsonTypeName("FacebookChannel")
@Fluent
public final class FacebookChannel extends Channel {
    /*
     * The set of properties specific to bot facebook channel
     */
    @JsonProperty(value = "properties")
    private FacebookChannelProperties properties;

    /**
     * Get the properties property: The set of properties specific to bot facebook channel.
     *
     * @return the properties value.
     */
    public FacebookChannelProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The set of properties specific to bot facebook channel.
     *
     * @param properties the properties value to set.
     * @return the FacebookChannel object itself.
     */
    public FacebookChannel withProperties(FacebookChannelProperties properties) {
        this.properties = properties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FacebookChannel withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FacebookChannel withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }
}
