// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The parameters to provide for the Line channel. */
@Fluent
public final class LineChannelProperties {
    /*
     * The list of line channel registrations
     */
    @JsonProperty(value = "lineRegistrations", required = true)
    private List<LineRegistration> lineRegistrations;

    /*
     * Callback Url to enter in line registration.
     */
    @JsonProperty(value = "callbackUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String callbackUrl;

    /*
     * Whether this channel is validated for the bot
     */
    @JsonProperty(value = "isValidated", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isValidated;

    /**
     * Get the lineRegistrations property: The list of line channel registrations.
     *
     * @return the lineRegistrations value.
     */
    public List<LineRegistration> lineRegistrations() {
        return this.lineRegistrations;
    }

    /**
     * Set the lineRegistrations property: The list of line channel registrations.
     *
     * @param lineRegistrations the lineRegistrations value to set.
     * @return the LineChannelProperties object itself.
     */
    public LineChannelProperties withLineRegistrations(List<LineRegistration> lineRegistrations) {
        this.lineRegistrations = lineRegistrations;
        return this;
    }

    /**
     * Get the callbackUrl property: Callback Url to enter in line registration.
     *
     * @return the callbackUrl value.
     */
    public String callbackUrl() {
        return this.callbackUrl;
    }

    /**
     * Get the isValidated property: Whether this channel is validated for the bot.
     *
     * @return the isValidated value.
     */
    public Boolean isValidated() {
        return this.isValidated;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (lineRegistrations() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property lineRegistrations in model LineChannelProperties"));
        } else {
            lineRegistrations().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LineChannelProperties.class);
}
