// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for MsaAppType. */
public final class MsaAppType extends ExpandableStringEnum<MsaAppType> {
    /** Static value UserAssignedMSI for MsaAppType. */
    public static final MsaAppType USER_ASSIGNED_MSI = fromString("UserAssignedMSI");

    /** Static value SingleTenant for MsaAppType. */
    public static final MsaAppType SINGLE_TENANT = fromString("SingleTenant");

    /** Static value MultiTenant for MsaAppType. */
    public static final MsaAppType MULTI_TENANT = fromString("MultiTenant");

    /**
     * Creates or finds a MsaAppType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MsaAppType.
     */
    @JsonCreator
    public static MsaAppType fromString(String name) {
        return fromString(name, MsaAppType.class);
    }

    /**
     * Gets known MsaAppType values.
     *
     * @return known MsaAppType values.
     */
    public static Collection<MsaAppType> values() {
        return values(MsaAppType.class);
    }
}
