// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.util.Context;

/** Resource collection API of OperationResults. */
public interface OperationResults {
    /**
     * Get the operation result for a long running operation.
     *
     * @param operationResultId The ID of the operation result to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the operation result for a long running operation.
     */
    OperationResultsDescription get(String operationResultId);

    /**
     * Get the operation result for a long running operation.
     *
     * @param operationResultId The ID of the operation result to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the operation result for a long running operation.
     */
    OperationResultsDescription get(String operationResultId, Context context);
}
