// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for RegenerateKeysChannelName. */
public enum RegenerateKeysChannelName {
    /** Enum value WebChatChannel. */
    WEB_CHAT_CHANNEL("WebChatChannel"),

    /** Enum value DirectLineChannel. */
    DIRECT_LINE_CHANNEL("DirectLineChannel");

    /** The actual serialized value for a RegenerateKeysChannelName instance. */
    private final String value;

    RegenerateKeysChannelName(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RegenerateKeysChannelName instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed RegenerateKeysChannelName object, or null if unable to parse.
     */
    @JsonCreator
    public static RegenerateKeysChannelName fromString(String value) {
        RegenerateKeysChannelName[] items = RegenerateKeysChannelName.values();
        for (RegenerateKeysChannelName item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
