// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Extra Parameters specific to each Service Provider. */
@Immutable
public final class ServiceProviderParameter {
    /*
     * Name of the Service Provider
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Type of the Service Provider
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Display Name of the Service Provider
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /*
     * Description of the Service Provider
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /*
     * Help Url for the  Service Provider
     */
    @JsonProperty(value = "helpUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String helpUrl;

    /*
     * Default Name for the Service Provider
     */
    @JsonProperty(value = "default", access = JsonProperty.Access.WRITE_ONLY)
    private String defaultProperty;

    /*
     * Meta data for the Service Provider
     */
    @JsonProperty(value = "metadata", access = JsonProperty.Access.WRITE_ONLY)
    private ServiceProviderParameterMetadata metadata;

    /**
     * Get the name property: Name of the Service Provider.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Type of the Service Provider.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the displayName property: Display Name of the Service Provider.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the description property: Description of the Service Provider.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the helpUrl property: Help Url for the Service Provider.
     *
     * @return the helpUrl value.
     */
    public String helpUrl() {
        return this.helpUrl;
    }

    /**
     * Get the defaultProperty property: Default Name for the Service Provider.
     *
     * @return the defaultProperty value.
     */
    public String defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Get the metadata property: Meta data for the Service Provider.
     *
     * @return the metadata value.
     */
    public ServiceProviderParameterMetadata metadata() {
        return this.metadata;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metadata() != null) {
            metadata().validate();
        }
    }
}
