// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Meta data for the Service Provider. */
@Fluent
public final class ServiceProviderParameterMetadata {
    /*
     * the constraints of the bot meta data.
     */
    @JsonProperty(value = "constraints")
    private ServiceProviderParameterMetadataConstraints constraints;

    /**
     * Get the constraints property: the constraints of the bot meta data.
     *
     * @return the constraints value.
     */
    public ServiceProviderParameterMetadataConstraints constraints() {
        return this.constraints;
    }

    /**
     * Set the constraints property: the constraints of the bot meta data.
     *
     * @param constraints the constraints value to set.
     * @return the ServiceProviderParameterMetadata object itself.
     */
    public ServiceProviderParameterMetadata withConstraints(ServiceProviderParameterMetadataConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (constraints() != null) {
            constraints().validate();
        }
    }
}
