// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The Object used to describe a Service Provider supported by Bot Service. */
@Fluent
public final class ServiceProviderProperties {
    /*
     * Id for Service Provider
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Display Name of the Service Provider
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /*
     * Display Name of the Service Provider
     */
    @JsonProperty(value = "serviceProviderName", access = JsonProperty.Access.WRITE_ONLY)
    private String serviceProviderName;

    /*
     * Display Name of the Service Provider
     */
    @JsonProperty(value = "devPortalUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String devPortalUrl;

    /*
     * Display Name of the Service Provider
     */
    @JsonProperty(value = "iconUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String iconUrl;

    /*
     * The list of parameters for the Service Provider
     */
    @JsonProperty(value = "parameters")
    private List<ServiceProviderParameter> parameters;

    /**
     * Get the id property: Id for Service Provider.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Display Name of the Service Provider.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the serviceProviderName property: Display Name of the Service Provider.
     *
     * @return the serviceProviderName value.
     */
    public String serviceProviderName() {
        return this.serviceProviderName;
    }

    /**
     * Get the devPortalUrl property: Display Name of the Service Provider.
     *
     * @return the devPortalUrl value.
     */
    public String devPortalUrl() {
        return this.devPortalUrl;
    }

    /**
     * Get the iconUrl property: Display Name of the Service Provider.
     *
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.iconUrl;
    }

    /**
     * Get the parameters property: The list of parameters for the Service Provider.
     *
     * @return the parameters value.
     */
    public List<ServiceProviderParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The list of parameters for the Service Provider.
     *
     * @param parameters the parameters value to set.
     * @return the ServiceProviderProperties object itself.
     */
    public ServiceProviderProperties withParameters(List<ServiceProviderParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }
}
