// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Site information for WebChat or DirectLine Channels to identify which site to regenerate keys for. */
@Fluent
public final class SiteInfo {
    /*
     * The site name
     */
    @JsonProperty(value = "siteName", required = true)
    private String siteName;

    /*
     * Determines which key is to be regenerated
     */
    @JsonProperty(value = "key", required = true)
    private Key key;

    /**
     * Get the siteName property: The site name.
     *
     * @return the siteName value.
     */
    public String siteName() {
        return this.siteName;
    }

    /**
     * Set the siteName property: The site name.
     *
     * @param siteName the siteName value to set.
     * @return the SiteInfo object itself.
     */
    public SiteInfo withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    /**
     * Get the key property: Determines which key is to be regenerated.
     *
     * @return the key value.
     */
    public Key key() {
        return this.key;
    }

    /**
     * Set the key property: Determines which key is to be regenerated.
     *
     * @param key the key value to set.
     * @return the SiteInfo object itself.
     */
    public SiteInfo withKey(Key key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (siteName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property siteName in model SiteInfo"));
        }
        if (key() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property key in model SiteInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SiteInfo.class);
}
