// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The parameters to provide for the Telegram channel. */
@Fluent
public final class TelegramChannelProperties {
    /*
     * The Telegram access token. Value only returned through POST to the
     * action Channel List API, otherwise empty.
     */
    @JsonProperty(value = "accessToken")
    private String accessToken;

    /*
     * Whether this channel is validated for the bot
     */
    @JsonProperty(value = "isValidated")
    private Boolean isValidated;

    /*
     * Whether this channel is enabled for the bot
     */
    @JsonProperty(value = "isEnabled", required = true)
    private boolean isEnabled;

    /**
     * Get the accessToken property: The Telegram access token. Value only returned through POST to the action Channel
     * List API, otherwise empty.
     *
     * @return the accessToken value.
     */
    public String accessToken() {
        return this.accessToken;
    }

    /**
     * Set the accessToken property: The Telegram access token. Value only returned through POST to the action Channel
     * List API, otherwise empty.
     *
     * @param accessToken the accessToken value to set.
     * @return the TelegramChannelProperties object itself.
     */
    public TelegramChannelProperties withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    /**
     * Get the isValidated property: Whether this channel is validated for the bot.
     *
     * @return the isValidated value.
     */
    public Boolean isValidated() {
        return this.isValidated;
    }

    /**
     * Set the isValidated property: Whether this channel is validated for the bot.
     *
     * @param isValidated the isValidated value to set.
     * @return the TelegramChannelProperties object itself.
     */
    public TelegramChannelProperties withIsValidated(Boolean isValidated) {
        this.isValidated = isValidated;
        return this;
    }

    /**
     * Get the isEnabled property: Whether this channel is enabled for the bot.
     *
     * @return the isEnabled value.
     */
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Whether this channel is enabled for the bot.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the TelegramChannelProperties object itself.
     */
    public TelegramChannelProperties withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
