// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The parameters to provide for the Web Chat channel. */
@Fluent
public final class WebChatChannelProperties {
    /*
     * Web chat control embed code
     */
    @JsonProperty(value = "webChatEmbedCode", access = JsonProperty.Access.WRITE_ONLY)
    private String webChatEmbedCode;

    /*
     * The list of Web Chat sites
     */
    @JsonProperty(value = "sites")
    private List<WebChatSite> sites;

    /**
     * Get the webChatEmbedCode property: Web chat control embed code.
     *
     * @return the webChatEmbedCode value.
     */
    public String webChatEmbedCode() {
        return this.webChatEmbedCode;
    }

    /**
     * Get the sites property: The list of Web Chat sites.
     *
     * @return the sites value.
     */
    public List<WebChatSite> sites() {
        return this.sites;
    }

    /**
     * Set the sites property: The list of Web Chat sites.
     *
     * @param sites the sites value to set.
     * @return the WebChatChannelProperties object itself.
     */
    public WebChatChannelProperties withSites(List<WebChatSite> sites) {
        this.sites = sites;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sites() != null) {
            sites().forEach(e -> e.validate());
        }
    }
}
