/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.fluent.AzureBotService;
import com.azure.resourcemanager.botservice.implementation.AzureBotServiceBuilder;
import com.azure.resourcemanager.botservice.implementation.BotConnectionsImpl;
import com.azure.resourcemanager.botservice.implementation.BotsImpl;
import com.azure.resourcemanager.botservice.implementation.ChannelsImpl;
import com.azure.resourcemanager.botservice.implementation.DirectLinesImpl;
import com.azure.resourcemanager.botservice.implementation.HostSettingsImpl;
import com.azure.resourcemanager.botservice.implementation.OperationResultsImpl;
import com.azure.resourcemanager.botservice.implementation.OperationsImpl;
import com.azure.resourcemanager.botservice.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.botservice.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.botservice.models.BotConnections;
import com.azure.resourcemanager.botservice.models.Bots;
import com.azure.resourcemanager.botservice.models.Channels;
import com.azure.resourcemanager.botservice.models.DirectLines;
import com.azure.resourcemanager.botservice.models.HostSettings;
import com.azure.resourcemanager.botservice.models.OperationResults;
import com.azure.resourcemanager.botservice.models.Operations;
import com.azure.resourcemanager.botservice.models.PrivateEndpointConnections;
import com.azure.resourcemanager.botservice.models.PrivateLinkResources;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BotServiceManager {
    private Bots bots;
    private Channels channels;
    private DirectLines directLines;
    private Operations operations;
    private BotConnections botConnections;
    private HostSettings hostSettings;
    private OperationResults operationResults;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private final AzureBotService clientObject;

    private BotServiceManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new AzureBotServiceBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static BotServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return BotServiceManager.configure().authenticate(credential, profile);
    }

    public static BotServiceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new BotServiceManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Bots bots() {
        if (this.bots == null) {
            this.bots = new BotsImpl(this.clientObject.getBots(), this);
        }
        return this.bots;
    }

    public Channels channels() {
        if (this.channels == null) {
            this.channels = new ChannelsImpl(this.clientObject.getChannels(), this);
        }
        return this.channels;
    }

    public DirectLines directLines() {
        if (this.directLines == null) {
            this.directLines = new DirectLinesImpl(this.clientObject.getDirectLines(), this);
        }
        return this.directLines;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public BotConnections botConnections() {
        if (this.botConnections == null) {
            this.botConnections = new BotConnectionsImpl(this.clientObject.getBotConnections(), this);
        }
        return this.botConnections;
    }

    public HostSettings hostSettings() {
        if (this.hostSettings == null) {
            this.hostSettings = new HostSettingsImpl(this.clientObject.getHostSettings(), this);
        }
        return this.hostSettings;
    }

    public OperationResults operationResults() {
        if (this.operationResults == null) {
            this.operationResults = new OperationResultsImpl(this.clientObject.getOperationResults(), this);
        }
        return this.operationResults;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public AzureBotService serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public BotServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.botservice").append("/").append("1.0.0-beta.5");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new BotServiceManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

