/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.botservice.models.BotProperties;
import com.azure.resourcemanager.botservice.models.Kind;
import com.azure.resourcemanager.botservice.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BotInner
extends Resource {
    @JsonProperty(value="properties")
    private BotProperties properties;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="kind")
    private Kind kind;
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="zones", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> zones;

    public BotProperties properties() {
        return this.properties;
    }

    public BotInner withProperties(BotProperties properties) {
        this.properties = properties;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public BotInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public BotInner withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public BotInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public BotInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BotInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

