/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.botservice.implementation.AzureBotServiceImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={AzureBotServiceImpl.class})
public final class AzureBotServiceBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public AzureBotServiceBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public AzureBotServiceBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AzureBotServiceBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public AzureBotServiceBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureBotServiceBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public AzureBotServiceBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public AzureBotServiceImpl buildClient() {
        if (this.endpoint == null) {
            this.endpoint = "https://management.azure.com";
        }
        if (this.environment == null) {
            this.environment = AzureEnvironment.AZURE;
        }
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        }
        if (this.defaultPollInterval == null) {
            this.defaultPollInterval = Duration.ofSeconds(30L);
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        }
        AzureBotServiceImpl client = new AzureBotServiceImpl(this.pipeline, this.serializerAdapter, this.defaultPollInterval, this.environment, this.subscriptionId, this.endpoint);
        return client;
    }
}

