/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.models.BotInner;
import com.azure.resourcemanager.botservice.implementation.Utils;
import com.azure.resourcemanager.botservice.models.Bot;
import com.azure.resourcemanager.botservice.models.BotProperties;
import com.azure.resourcemanager.botservice.models.Kind;
import com.azure.resourcemanager.botservice.models.Sku;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BotImpl
implements Bot,
Bot.Definition,
Bot.Update {
    private BotInner innerObject;
    private final BotServiceManager serviceManager;
    private String resourceGroupName;
    private String resourceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public BotProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public Kind kind() {
        return this.innerModel().kind();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BotInner innerModel() {
        return this.innerObject;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }

    @Override
    public BotImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Bot create() {
        this.innerObject = (BotInner)((Object)this.serviceManager.serviceClient().getBots().createWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Bot create(Context context) {
        this.innerObject = (BotInner)((Object)this.serviceManager.serviceClient().getBots().createWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), context).getValue());
        return this;
    }

    BotImpl(String name, BotServiceManager serviceManager) {
        this.innerObject = new BotInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
    }

    @Override
    public BotImpl update() {
        return this;
    }

    @Override
    public Bot apply() {
        this.innerObject = (BotInner)((Object)this.serviceManager.serviceClient().getBots().updateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Bot apply(Context context) {
        this.innerObject = (BotInner)((Object)this.serviceManager.serviceClient().getBots().updateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), context).getValue());
        return this;
    }

    BotImpl(BotInner innerObject, BotServiceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "botServices");
    }

    @Override
    public Bot refresh() {
        this.innerObject = (BotInner)((Object)this.serviceManager.serviceClient().getBots().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Bot refresh(Context context) {
        this.innerObject = (BotInner)((Object)this.serviceManager.serviceClient().getBots().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, context).getValue());
        return this;
    }

    @Override
    public BotImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BotImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BotImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public BotImpl withProperties(BotProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public BotImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public BotImpl withKind(Kind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public BotImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }
}

