/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.BotsClient;
import com.azure.resourcemanager.botservice.fluent.models.BotInner;
import com.azure.resourcemanager.botservice.fluent.models.CheckNameAvailabilityResponseBodyInner;
import com.azure.resourcemanager.botservice.implementation.BotImpl;
import com.azure.resourcemanager.botservice.implementation.CheckNameAvailabilityResponseBodyImpl;
import com.azure.resourcemanager.botservice.implementation.Utils;
import com.azure.resourcemanager.botservice.models.Bot;
import com.azure.resourcemanager.botservice.models.Bots;
import com.azure.resourcemanager.botservice.models.CheckNameAvailabilityRequestBody;
import com.azure.resourcemanager.botservice.models.CheckNameAvailabilityResponseBody;

public final class BotsImpl
implements Bots {
    private static final ClientLogger LOGGER = new ClientLogger(BotsImpl.class);
    private final BotsClient innerClient;
    private final BotServiceManager serviceManager;

    public BotsImpl(BotsClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String resourceName) {
        this.serviceClient().delete(resourceGroupName, resourceName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public Bot getByResourceGroup(String resourceGroupName, String resourceName) {
        BotInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, resourceName);
        if (inner != null) {
            return new BotImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Bot> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<BotInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BotImpl((BotInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<Bot> listByResourceGroup(String resourceGroupName) {
        PagedIterable<BotInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new BotImpl((BotInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Bot> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<BotInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new BotImpl((BotInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Bot> list() {
        PagedIterable<BotInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new BotImpl((BotInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Bot> list(Context context) {
        PagedIterable<BotInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new BotImpl((BotInner)((Object)inner1), this.manager()));
    }

    @Override
    public CheckNameAvailabilityResponseBody getCheckNameAvailability(CheckNameAvailabilityRequestBody parameters) {
        CheckNameAvailabilityResponseBodyInner inner = this.serviceClient().getCheckNameAvailability(parameters);
        if (inner != null) {
            return new CheckNameAvailabilityResponseBodyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CheckNameAvailabilityResponseBody> getCheckNameAvailabilityWithResponse(CheckNameAvailabilityRequestBody parameters, Context context) {
        Response<CheckNameAvailabilityResponseBodyInner> inner = this.serviceClient().getCheckNameAvailabilityWithResponse(parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResponseBodyImpl((CheckNameAvailabilityResponseBodyInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Bot getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "botServices");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'botServices'.", id)));
        }
        return (Bot)this.getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @Override
    public Response<Bot> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "botServices");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'botServices'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "botServices");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'botServices'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, resourceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "botServices");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'botServices'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, resourceName, context);
    }

    private BotsClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }

    @Override
    public BotImpl define(String name) {
        return new BotImpl(name, this.manager());
    }
}

