/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.ChannelsClient;
import com.azure.resourcemanager.botservice.fluent.models.BotChannelInner;
import com.azure.resourcemanager.botservice.fluent.models.ListChannelWithKeysResponseInner;
import com.azure.resourcemanager.botservice.implementation.BotChannelImpl;
import com.azure.resourcemanager.botservice.implementation.ListChannelWithKeysResponseImpl;
import com.azure.resourcemanager.botservice.implementation.Utils;
import com.azure.resourcemanager.botservice.models.BotChannel;
import com.azure.resourcemanager.botservice.models.ChannelName;
import com.azure.resourcemanager.botservice.models.Channels;
import com.azure.resourcemanager.botservice.models.ListChannelWithKeysResponse;

public final class ChannelsImpl
implements Channels {
    private static final ClientLogger LOGGER = new ClientLogger(ChannelsImpl.class);
    private final ChannelsClient innerClient;
    private final BotServiceManager serviceManager;

    public ChannelsImpl(ChannelsClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public BotChannel create(String resourceGroupName, String resourceName, ChannelName channelName, BotChannelInner parameters) {
        BotChannelInner inner = this.serviceClient().create(resourceGroupName, resourceName, channelName, parameters);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BotChannel> createWithResponse(String resourceGroupName, String resourceName, ChannelName channelName, BotChannelInner parameters, Context context) {
        Response<BotChannelInner> inner = this.serviceClient().createWithResponse(resourceGroupName, resourceName, channelName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BotChannelImpl((BotChannelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BotChannel update(String resourceGroupName, String resourceName, ChannelName channelName, BotChannelInner parameters) {
        BotChannelInner inner = this.serviceClient().update(resourceGroupName, resourceName, channelName, parameters);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BotChannel> updateWithResponse(String resourceGroupName, String resourceName, ChannelName channelName, BotChannelInner parameters, Context context) {
        Response<BotChannelInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, resourceName, channelName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BotChannelImpl((BotChannelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, String channelName) {
        this.serviceClient().delete(resourceGroupName, resourceName, channelName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String channelName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, channelName, context);
    }

    @Override
    public BotChannel get(String resourceGroupName, String resourceName, String channelName) {
        BotChannelInner inner = this.serviceClient().get(resourceGroupName, resourceName, channelName);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BotChannel> getWithResponse(String resourceGroupName, String resourceName, String channelName, Context context) {
        Response<BotChannelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, channelName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BotChannelImpl((BotChannelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ListChannelWithKeysResponse listWithKeys(String resourceGroupName, String resourceName, ChannelName channelName) {
        ListChannelWithKeysResponseInner inner = this.serviceClient().listWithKeys(resourceGroupName, resourceName, channelName);
        if (inner != null) {
            return new ListChannelWithKeysResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ListChannelWithKeysResponse> listWithKeysWithResponse(String resourceGroupName, String resourceName, ChannelName channelName, Context context) {
        Response<ListChannelWithKeysResponseInner> inner = this.serviceClient().listWithKeysWithResponse(resourceGroupName, resourceName, channelName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ListChannelWithKeysResponseImpl((ListChannelWithKeysResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<BotChannel> listByResourceGroup(String resourceGroupName, String resourceName) {
        PagedIterable<BotChannelInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new BotChannelImpl((BotChannelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BotChannel> listByResourceGroup(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<BotChannelInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new BotChannelImpl((BotChannelInner)((Object)inner1), this.manager()));
    }

    private ChannelsClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }
}

