/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.models.ConnectionSettingInner;
import com.azure.resourcemanager.botservice.implementation.Utils;
import com.azure.resourcemanager.botservice.models.ConnectionSetting;
import com.azure.resourcemanager.botservice.models.ConnectionSettingProperties;
import com.azure.resourcemanager.botservice.models.Kind;
import com.azure.resourcemanager.botservice.models.Sku;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ConnectionSettingImpl
implements ConnectionSetting,
ConnectionSetting.Definition,
ConnectionSetting.Update {
    private ConnectionSettingInner innerObject;
    private final BotServiceManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private String connectionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ConnectionSettingProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public Kind kind() {
        return this.innerModel().kind();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConnectionSettingInner innerModel() {
        return this.innerObject;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectionSettingImpl withExistingBotService(String resourceGroupName, String resourceName) {
        this.resourceGroupName = resourceGroupName;
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ConnectionSetting create() {
        this.innerObject = (ConnectionSettingInner)((Object)this.serviceManager.serviceClient().getBotConnections().createWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectionSetting create(Context context) {
        this.innerObject = (ConnectionSettingInner)((Object)this.serviceManager.serviceClient().getBotConnections().createWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, this.innerModel(), context).getValue());
        return this;
    }

    ConnectionSettingImpl(String name, BotServiceManager serviceManager) {
        this.innerObject = new ConnectionSettingInner();
        this.serviceManager = serviceManager;
        this.connectionName = name;
    }

    @Override
    public ConnectionSettingImpl update() {
        return this;
    }

    @Override
    public ConnectionSetting apply() {
        this.innerObject = (ConnectionSettingInner)((Object)this.serviceManager.serviceClient().getBotConnections().updateWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectionSetting apply(Context context) {
        this.innerObject = (ConnectionSettingInner)((Object)this.serviceManager.serviceClient().getBotConnections().updateWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, this.innerModel(), context).getValue());
        return this;
    }

    ConnectionSettingImpl(ConnectionSettingInner innerObject, BotServiceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "botServices");
        this.connectionName = Utils.getValueFromIdByName(innerObject.id(), "connections");
    }

    @Override
    public ConnectionSetting refresh() {
        this.innerObject = (ConnectionSettingInner)((Object)this.serviceManager.serviceClient().getBotConnections().getWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectionSetting refresh(Context context) {
        this.innerObject = (ConnectionSettingInner)((Object)this.serviceManager.serviceClient().getBotConnections().getWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, context).getValue());
        return this;
    }

    @Override
    public ConnectionSetting listWithSecrets() {
        return this.serviceManager.botConnections().listWithSecrets(this.resourceGroupName, this.resourceName, this.connectionName);
    }

    @Override
    public Response<ConnectionSetting> listWithSecretsWithResponse(Context context) {
        return this.serviceManager.botConnections().listWithSecretsWithResponse(this.resourceGroupName, this.resourceName, this.connectionName, context);
    }

    @Override
    public ConnectionSettingImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ConnectionSettingImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ConnectionSettingImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ConnectionSettingImpl withProperties(ConnectionSettingProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ConnectionSettingImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public ConnectionSettingImpl withKind(Kind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public ConnectionSettingImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }
}

