/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.botservice.fluent.DirectLinesClient;
import com.azure.resourcemanager.botservice.fluent.models.BotChannelInner;
import com.azure.resourcemanager.botservice.implementation.AzureBotServiceImpl;
import com.azure.resourcemanager.botservice.models.RegenerateKeysChannelName;
import com.azure.resourcemanager.botservice.models.SiteInfo;
import reactor.core.publisher.Mono;

public final class DirectLinesClientImpl
implements DirectLinesClient {
    private final DirectLinesService service;
    private final AzureBotServiceImpl client;

    DirectLinesClientImpl(AzureBotServiceImpl client) {
        this.service = (DirectLinesService)RestProxy.create(DirectLinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BotChannelInner>> regenerateKeysWithResponseAsync(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateKeys(this.client.getEndpoint(), resourceGroupName, resourceName, this.client.getSubscriptionId(), channelName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BotChannelInner>> regenerateKeysWithResponseAsync(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateKeys(this.client.getEndpoint(), resourceGroupName, resourceName, this.client.getSubscriptionId(), channelName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BotChannelInner> regenerateKeysAsync(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        return this.regenerateKeysWithResponseAsync(resourceGroupName, resourceName, channelName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BotChannelInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BotChannelInner regenerateKeys(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        return (BotChannelInner)((Object)this.regenerateKeysAsync(resourceGroupName, resourceName, channelName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BotChannelInner> regenerateKeysWithResponse(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters, Context context) {
        return (Response)this.regenerateKeysWithResponseAsync(resourceGroupName, resourceName, channelName, parameters, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureBotServiceDirec")
    private static interface DirectLinesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}/regeneratekeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BotChannelInner>> regenerateKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="channelName") RegenerateKeysChannelName var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SiteInfo var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

