/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.DirectLinesClient;
import com.azure.resourcemanager.botservice.fluent.models.BotChannelInner;
import com.azure.resourcemanager.botservice.implementation.BotChannelImpl;
import com.azure.resourcemanager.botservice.models.BotChannel;
import com.azure.resourcemanager.botservice.models.DirectLines;
import com.azure.resourcemanager.botservice.models.RegenerateKeysChannelName;
import com.azure.resourcemanager.botservice.models.SiteInfo;

public final class DirectLinesImpl
implements DirectLines {
    private static final ClientLogger LOGGER = new ClientLogger(DirectLinesImpl.class);
    private final DirectLinesClient innerClient;
    private final BotServiceManager serviceManager;

    public DirectLinesImpl(DirectLinesClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public BotChannel regenerateKeys(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        BotChannelInner inner = this.serviceClient().regenerateKeys(resourceGroupName, resourceName, channelName, parameters);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BotChannel> regenerateKeysWithResponse(String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters, Context context) {
        Response<BotChannelInner> inner = this.serviceClient().regenerateKeysWithResponse(resourceGroupName, resourceName, channelName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BotChannelImpl((BotChannelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    private DirectLinesClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }
}

