/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.HostSettingsClient;
import com.azure.resourcemanager.botservice.fluent.models.HostSettingsResponseInner;
import com.azure.resourcemanager.botservice.implementation.HostSettingsResponseImpl;
import com.azure.resourcemanager.botservice.models.HostSettings;
import com.azure.resourcemanager.botservice.models.HostSettingsResponse;

public final class HostSettingsImpl
implements HostSettings {
    private static final ClientLogger LOGGER = new ClientLogger(HostSettingsImpl.class);
    private final HostSettingsClient innerClient;
    private final BotServiceManager serviceManager;

    public HostSettingsImpl(HostSettingsClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public HostSettingsResponse get() {
        HostSettingsResponseInner inner = this.serviceClient().get();
        if (inner != null) {
            return new HostSettingsResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<HostSettingsResponse> getWithResponse(Context context) {
        Response<HostSettingsResponseInner> inner = this.serviceClient().getWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new HostSettingsResponseImpl((HostSettingsResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private HostSettingsClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }
}

