/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.botservice.fluent.OperationResultsClient;
import com.azure.resourcemanager.botservice.fluent.models.OperationResultsDescriptionInner;
import com.azure.resourcemanager.botservice.implementation.AzureBotServiceImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OperationResultsClientImpl
implements OperationResultsClient {
    private final OperationResultsService service;
    private final AzureBotServiceImpl client;

    OperationResultsClientImpl(AzureBotServiceImpl client) {
        this.service = (OperationResultsService)RestProxy.create(OperationResultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getWithResponseAsync(String operationResultId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (operationResultId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationResultId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), operationResultId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getWithResponseAsync(String operationResultId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (operationResultId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationResultId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), operationResultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultsDescriptionInner>, OperationResultsDescriptionInner> beginGetAsync(String operationResultId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.getWithResponseAsync(operationResultId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultsDescriptionInner.class), (Type)((Object)OperationResultsDescriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationResultsDescriptionInner>, OperationResultsDescriptionInner> beginGetAsync(String operationResultId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.getWithResponseAsync(operationResultId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationResultsDescriptionInner.class), (Type)((Object)OperationResultsDescriptionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultsDescriptionInner>, OperationResultsDescriptionInner> beginGet(String operationResultId) {
        return this.beginGetAsync(operationResultId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationResultsDescriptionInner>, OperationResultsDescriptionInner> beginGet(String operationResultId, Context context) {
        return this.beginGetAsync(operationResultId, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultsDescriptionInner> getAsync(String operationResultId) {
        return this.beginGetAsync(operationResultId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResultsDescriptionInner> getAsync(String operationResultId, Context context) {
        return this.beginGetAsync(operationResultId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultsDescriptionInner get(String operationResultId) {
        return (OperationResultsDescriptionInner)this.getAsync(operationResultId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResultsDescriptionInner get(String operationResultId, Context context) {
        return (OperationResultsDescriptionInner)this.getAsync(operationResultId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureBotServiceOpera")
    private static interface OperationResultsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.BotService/operationresults/{operationResultId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="operationResultId") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

