/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.OperationResultsClient;
import com.azure.resourcemanager.botservice.fluent.models.OperationResultsDescriptionInner;
import com.azure.resourcemanager.botservice.implementation.OperationResultsDescriptionImpl;
import com.azure.resourcemanager.botservice.models.OperationResults;
import com.azure.resourcemanager.botservice.models.OperationResultsDescription;

public final class OperationResultsImpl
implements OperationResults {
    private static final ClientLogger LOGGER = new ClientLogger(OperationResultsImpl.class);
    private final OperationResultsClient innerClient;
    private final BotServiceManager serviceManager;

    public OperationResultsImpl(OperationResultsClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public OperationResultsDescription get(String operationResultId) {
        OperationResultsDescriptionInner inner = this.serviceClient().get(operationResultId);
        if (inner != null) {
            return new OperationResultsDescriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationResultsDescription get(String operationResultId, Context context) {
        OperationResultsDescriptionInner inner = this.serviceClient().get(operationResultId, context);
        if (inner != null) {
            return new OperationResultsDescriptionImpl(inner, this.manager());
        }
        return null;
    }

    private OperationResultsClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }
}

