/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.OperationsClient;
import com.azure.resourcemanager.botservice.fluent.models.OperationEntityInner;
import com.azure.resourcemanager.botservice.implementation.OperationEntityImpl;
import com.azure.resourcemanager.botservice.implementation.Utils;
import com.azure.resourcemanager.botservice.models.OperationEntity;
import com.azure.resourcemanager.botservice.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final BotServiceManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationEntity> list() {
        PagedIterable<OperationEntityInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new OperationEntityImpl((OperationEntityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationEntity> list(Context context) {
        PagedIterable<OperationEntityInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new OperationEntityImpl((OperationEntityInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }
}

