/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.BotServiceManager;
import com.azure.resourcemanager.botservice.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.botservice.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.botservice.implementation.PrivateLinkResourceListResultImpl;
import com.azure.resourcemanager.botservice.models.PrivateLinkResourceListResult;
import com.azure.resourcemanager.botservice.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final BotServiceManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PrivateLinkResourceListResult listByBotResource(String resourceGroupName, String resourceName) {
        PrivateLinkResourceListResultInner inner = this.serviceClient().listByBotResource(resourceGroupName, resourceName);
        if (inner != null) {
            return new PrivateLinkResourceListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PrivateLinkResourceListResult> listByBotResourceWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<PrivateLinkResourceListResultInner> inner = this.serviceClient().listByBotResourceWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceListResultImpl((PrivateLinkResourceListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private BotServiceManager manager() {
        return this.serviceManager;
    }
}

