/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.botservice.models.MsaAppType;
import com.azure.resourcemanager.botservice.models.PublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class BotProperties {
    @JsonProperty(value="displayName", required=true)
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="iconUrl")
    private String iconUrl;
    @JsonProperty(value="endpoint", required=true)
    private String endpoint;
    @JsonProperty(value="endpointVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String endpointVersion;
    @JsonProperty(value="allSettings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> allSettings;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> parameters;
    @JsonProperty(value="manifestUrl")
    private String manifestUrl;
    @JsonProperty(value="msaAppType")
    private MsaAppType msaAppType;
    @JsonProperty(value="msaAppId", required=true)
    private String msaAppId;
    @JsonProperty(value="msaAppTenantId")
    private String msaAppTenantId;
    @JsonProperty(value="msaAppMSIResourceId")
    private String msaAppMsiResourceId;
    @JsonProperty(value="configuredChannels", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> configuredChannels;
    @JsonProperty(value="enabledChannels", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> enabledChannels;
    @JsonProperty(value="developerAppInsightKey")
    private String developerAppInsightKey;
    @JsonProperty(value="developerAppInsightsApiKey")
    private String developerAppInsightsApiKey;
    @JsonProperty(value="developerAppInsightsApplicationId")
    private String developerAppInsightsApplicationId;
    @JsonProperty(value="luisAppIds")
    private List<String> luisAppIds;
    @JsonProperty(value="luisKey")
    private String luisKey;
    @JsonProperty(value="isCmekEnabled")
    private Boolean isCmekEnabled;
    @JsonProperty(value="cmekKeyVaultUrl")
    private String cmekKeyVaultUrl;
    @JsonProperty(value="cmekEncryptionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String cmekEncryptionStatus;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="isStreamingSupported")
    private Boolean isStreamingSupported;
    @JsonProperty(value="isDeveloperAppInsightsApiKeySet", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isDeveloperAppInsightsApiKeySet;
    @JsonProperty(value="migrationToken", access=JsonProperty.Access.WRITE_ONLY)
    private String migrationToken;
    @JsonProperty(value="disableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="schemaTransformationVersion")
    private String schemaTransformationVersion;
    @JsonProperty(value="storageResourceId")
    private String storageResourceId;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="openWithHint")
    private String openWithHint;
    @JsonProperty(value="appPasswordHint")
    private String appPasswordHint;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="publishingCredentials")
    private String publishingCredentials;
    private static final ClientLogger LOGGER = new ClientLogger(BotProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public BotProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public BotProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public BotProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public BotProperties withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String endpointVersion() {
        return this.endpointVersion;
    }

    public Map<String, String> allSettings() {
        return this.allSettings;
    }

    public BotProperties withAllSettings(Map<String, String> allSettings) {
        this.allSettings = allSettings;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public BotProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String manifestUrl() {
        return this.manifestUrl;
    }

    public BotProperties withManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
        return this;
    }

    public MsaAppType msaAppType() {
        return this.msaAppType;
    }

    public BotProperties withMsaAppType(MsaAppType msaAppType) {
        this.msaAppType = msaAppType;
        return this;
    }

    public String msaAppId() {
        return this.msaAppId;
    }

    public BotProperties withMsaAppId(String msaAppId) {
        this.msaAppId = msaAppId;
        return this;
    }

    public String msaAppTenantId() {
        return this.msaAppTenantId;
    }

    public BotProperties withMsaAppTenantId(String msaAppTenantId) {
        this.msaAppTenantId = msaAppTenantId;
        return this;
    }

    public String msaAppMsiResourceId() {
        return this.msaAppMsiResourceId;
    }

    public BotProperties withMsaAppMsiResourceId(String msaAppMsiResourceId) {
        this.msaAppMsiResourceId = msaAppMsiResourceId;
        return this;
    }

    public List<String> configuredChannels() {
        return this.configuredChannels;
    }

    public List<String> enabledChannels() {
        return this.enabledChannels;
    }

    public String developerAppInsightKey() {
        return this.developerAppInsightKey;
    }

    public BotProperties withDeveloperAppInsightKey(String developerAppInsightKey) {
        this.developerAppInsightKey = developerAppInsightKey;
        return this;
    }

    public String developerAppInsightsApiKey() {
        return this.developerAppInsightsApiKey;
    }

    public BotProperties withDeveloperAppInsightsApiKey(String developerAppInsightsApiKey) {
        this.developerAppInsightsApiKey = developerAppInsightsApiKey;
        return this;
    }

    public String developerAppInsightsApplicationId() {
        return this.developerAppInsightsApplicationId;
    }

    public BotProperties withDeveloperAppInsightsApplicationId(String developerAppInsightsApplicationId) {
        this.developerAppInsightsApplicationId = developerAppInsightsApplicationId;
        return this;
    }

    public List<String> luisAppIds() {
        return this.luisAppIds;
    }

    public BotProperties withLuisAppIds(List<String> luisAppIds) {
        this.luisAppIds = luisAppIds;
        return this;
    }

    public String luisKey() {
        return this.luisKey;
    }

    public BotProperties withLuisKey(String luisKey) {
        this.luisKey = luisKey;
        return this;
    }

    public Boolean isCmekEnabled() {
        return this.isCmekEnabled;
    }

    public BotProperties withIsCmekEnabled(Boolean isCmekEnabled) {
        this.isCmekEnabled = isCmekEnabled;
        return this;
    }

    public String cmekKeyVaultUrl() {
        return this.cmekKeyVaultUrl;
    }

    public BotProperties withCmekKeyVaultUrl(String cmekKeyVaultUrl) {
        this.cmekKeyVaultUrl = cmekKeyVaultUrl;
        return this;
    }

    public String cmekEncryptionStatus() {
        return this.cmekEncryptionStatus;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public BotProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean isStreamingSupported() {
        return this.isStreamingSupported;
    }

    public BotProperties withIsStreamingSupported(Boolean isStreamingSupported) {
        this.isStreamingSupported = isStreamingSupported;
        return this;
    }

    public Boolean isDeveloperAppInsightsApiKeySet() {
        return this.isDeveloperAppInsightsApiKeySet;
    }

    public String migrationToken() {
        return this.migrationToken;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public BotProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public String schemaTransformationVersion() {
        return this.schemaTransformationVersion;
    }

    public BotProperties withSchemaTransformationVersion(String schemaTransformationVersion) {
        this.schemaTransformationVersion = schemaTransformationVersion;
        return this;
    }

    public String storageResourceId() {
        return this.storageResourceId;
    }

    public BotProperties withStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String openWithHint() {
        return this.openWithHint;
    }

    public BotProperties withOpenWithHint(String openWithHint) {
        this.openWithHint = openWithHint;
        return this;
    }

    public String appPasswordHint() {
        return this.appPasswordHint;
    }

    public BotProperties withAppPasswordHint(String appPasswordHint) {
        this.appPasswordHint = appPasswordHint;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String publishingCredentials() {
        return this.publishingCredentials;
    }

    public BotProperties withPublishingCredentials(String publishingCredentials) {
        this.publishingCredentials = publishingCredentials;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property displayName in model BotProperties"));
        }
        if (this.endpoint() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property endpoint in model BotProperties"));
        }
        if (this.msaAppId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property msaAppId in model BotProperties"));
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

