/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.botservice.fluent.models.ConnectionSettingInner;
import com.azure.resourcemanager.botservice.models.ConnectionSettingProperties;
import com.azure.resourcemanager.botservice.models.Kind;
import com.azure.resourcemanager.botservice.models.Sku;
import java.util.List;
import java.util.Map;

public interface ConnectionSetting {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ConnectionSettingProperties properties();

    public Sku sku();

    public Kind kind();

    public String etag();

    public List<String> zones();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ConnectionSettingInner innerModel();

    public Update update();

    public ConnectionSetting refresh();

    public ConnectionSetting refresh(Context var1);

    public ConnectionSetting listWithSecrets();

    public Response<ConnectionSetting> listWithSecretsWithResponse(Context var1);

    public static interface UpdateStages {

        public static interface WithEtag {
            public Update withEtag(String var1);
        }

        public static interface WithKind {
            public Update withKind(Kind var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithProperties {
            public Update withProperties(ConnectionSettingProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties,
    UpdateStages.WithSku,
    UpdateStages.WithKind,
    UpdateStages.WithEtag {
        public ConnectionSetting apply();

        public ConnectionSetting apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithKind {
            public WithCreate withKind(Kind var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(ConnectionSettingProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithSku,
        WithKind,
        WithEtag {
            public ConnectionSetting create();

            public ConnectionSetting create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingBotService(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

