/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.models.FacebookPage;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class FacebookChannelProperties {
    @JsonProperty(value="verifyToken", access=JsonProperty.Access.WRITE_ONLY)
    private String verifyToken;
    @JsonProperty(value="pages")
    private List<FacebookPage> pages;
    @JsonProperty(value="appId", required=true)
    private String appId;
    @JsonProperty(value="appSecret")
    private String appSecret;
    @JsonProperty(value="callbackUrl", access=JsonProperty.Access.WRITE_ONLY)
    private String callbackUrl;
    @JsonProperty(value="isEnabled", required=true)
    private boolean isEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(FacebookChannelProperties.class);

    public String verifyToken() {
        return this.verifyToken;
    }

    public List<FacebookPage> pages() {
        return this.pages;
    }

    public FacebookChannelProperties withPages(List<FacebookPage> pages) {
        this.pages = pages;
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public FacebookChannelProperties withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String appSecret() {
        return this.appSecret;
    }

    public FacebookChannelProperties withAppSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public FacebookChannelProperties withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public void validate() {
        if (this.pages() != null) {
            this.pages().forEach(e -> e.validate());
        }
        if (this.appId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property appId in model FacebookChannelProperties"));
        }
    }
}

