/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.botservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.models.WebChatSite;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Site
extends WebChatSite {
    @JsonProperty(value="isTokenEnabled")
    private Boolean isTokenEnabled;
    @JsonProperty(value="eTag")
    private String etag;
    @JsonProperty(value="siteId", access=JsonProperty.Access.WRITE_ONLY)
    private String siteId;
    @JsonProperty(value="siteName", required=true)
    private String siteName;
    @JsonProperty(value="key", access=JsonProperty.Access.WRITE_ONLY)
    private String key;
    @JsonProperty(value="key2", access=JsonProperty.Access.WRITE_ONLY)
    private String key2;
    @JsonProperty(value="isEnabled", required=true)
    private boolean isEnabled;
    @JsonProperty(value="isV1Enabled", required=true)
    private boolean isV1Enabled;
    @JsonProperty(value="isV3Enabled", required=true)
    private boolean isV3Enabled;
    @JsonProperty(value="isSecureSiteEnabled")
    private Boolean isSecureSiteEnabled;
    @JsonProperty(value="isBlockUserUploadEnabled")
    private Boolean isBlockUserUploadEnabled;
    @JsonProperty(value="trustedOrigins")
    private List<String> trustedOrigins;
    private static final ClientLogger LOGGER = new ClientLogger(Site.class);

    public Boolean isTokenEnabled() {
        return this.isTokenEnabled;
    }

    public Site withIsTokenEnabled(Boolean isTokenEnabled) {
        this.isTokenEnabled = isTokenEnabled;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public Site withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    @Override
    public String siteId() {
        return this.siteId;
    }

    @Override
    public String siteName() {
        return this.siteName;
    }

    @Override
    public Site withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String key2() {
        return this.key2;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Site withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public boolean isV1Enabled() {
        return this.isV1Enabled;
    }

    public Site withIsV1Enabled(boolean isV1Enabled) {
        this.isV1Enabled = isV1Enabled;
        return this;
    }

    public boolean isV3Enabled() {
        return this.isV3Enabled;
    }

    public Site withIsV3Enabled(boolean isV3Enabled) {
        this.isV3Enabled = isV3Enabled;
        return this;
    }

    public Boolean isSecureSiteEnabled() {
        return this.isSecureSiteEnabled;
    }

    public Site withIsSecureSiteEnabled(Boolean isSecureSiteEnabled) {
        this.isSecureSiteEnabled = isSecureSiteEnabled;
        return this;
    }

    public Boolean isBlockUserUploadEnabled() {
        return this.isBlockUserUploadEnabled;
    }

    public Site withIsBlockUserUploadEnabled(Boolean isBlockUserUploadEnabled) {
        this.isBlockUserUploadEnabled = isBlockUserUploadEnabled;
        return this;
    }

    public List<String> trustedOrigins() {
        return this.trustedOrigins;
    }

    public Site withTrustedOrigins(List<String> trustedOrigins) {
        this.trustedOrigins = trustedOrigins;
        return this;
    }

    @Override
    public Site withIsWebchatPreviewEnabled(boolean isWebchatPreviewEnabled) {
        super.withIsWebchatPreviewEnabled(isWebchatPreviewEnabled);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.siteName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property siteName in model Site"));
        }
    }
}

