/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class CdnWebApplicationFirewallPolicyInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CdnWebApplicationFirewallPolicyInner.class);
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="properties.policySettings")
    private PolicySettings policySettings;
    @JsonProperty(value="properties.rateLimitRules")
    private RateLimitRuleList rateLimitRules;
    @JsonProperty(value="properties.customRules")
    private CustomRuleList customRules;
    @JsonProperty(value="properties.managedRules")
    private ManagedRuleSetList managedRules;
    @JsonProperty(value="properties.endpointLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<EndpointResource> endpointLinks;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private PolicyResourceState resourceState;

    public String etag() {
        return this.etag;
    }

    public CdnWebApplicationFirewallPolicyInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public CdnWebApplicationFirewallPolicyInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public CdnWebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public RateLimitRuleList rateLimitRules() {
        return this.rateLimitRules;
    }

    public CdnWebApplicationFirewallPolicyInner withRateLimitRules(RateLimitRuleList rateLimitRules) {
        this.rateLimitRules = rateLimitRules;
        return this;
    }

    public CustomRuleList customRules() {
        return this.customRules;
    }

    public CdnWebApplicationFirewallPolicyInner withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    public CdnWebApplicationFirewallPolicyInner withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<EndpointResource> endpointLinks() {
        return this.endpointLinks;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    public CdnWebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CdnWebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model CdnWebApplicationFirewallPolicyInner"));
        }
        this.sku().validate();
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.rateLimitRules() != null) {
            this.rateLimitRules().validate();
        }
        if (this.customRules() != null) {
            this.customRules().validate();
        }
        if (this.managedRules() != null) {
            this.managedRules().validate();
        }
        if (this.endpointLinks() != null) {
            this.endpointLinks().forEach(e -> e.validate());
        }
    }
}

