/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class OriginGroupUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OriginGroupUpdateParameters.class);
    @JsonProperty(value="properties.healthProbeSettings")
    private HealthProbeParameters healthProbeSettings;
    @JsonProperty(value="properties.origins")
    private List<ResourceReference> origins;
    @JsonProperty(value="properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    @JsonProperty(value="properties.responseBasedOriginErrorDetectionSettings")
    private ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings;

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public OriginGroupUpdateParameters withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public List<ResourceReference> origins() {
        return this.origins;
    }

    public OriginGroupUpdateParameters withOrigins(List<ResourceReference> origins) {
        this.origins = origins;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public OriginGroupUpdateParameters withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.responseBasedOriginErrorDetectionSettings;
    }

    public OriginGroupUpdateParameters withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        this.responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings;
        return this;
    }

    public void validate() {
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.origins() != null) {
            this.origins().forEach(e -> e.validate());
        }
        if (this.responseBasedOriginErrorDetectionSettings() != null) {
            this.responseBasedOriginErrorDetectionSettings().validate();
        }
    }
}

