/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchProcessingBehavior;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class RuleUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RuleUpdateParameters.class);
    @JsonProperty(value="properties.order")
    private Integer order;
    @JsonProperty(value="properties.conditions")
    private List<DeliveryRuleCondition> conditions;
    @JsonProperty(value="properties.actions")
    private List<DeliveryRuleAction> actions;
    @JsonProperty(value="properties.matchProcessingBehavior")
    private MatchProcessingBehavior matchProcessingBehavior;

    public Integer order() {
        return this.order;
    }

    public RuleUpdateParameters withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public List<DeliveryRuleCondition> conditions() {
        return this.conditions;
    }

    public RuleUpdateParameters withConditions(List<DeliveryRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public List<DeliveryRuleAction> actions() {
        return this.actions;
    }

    public RuleUpdateParameters withActions(List<DeliveryRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public MatchProcessingBehavior matchProcessingBehavior() {
        return this.matchProcessingBehavior;
    }

    public RuleUpdateParameters withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        this.matchProcessingBehavior = matchProcessingBehavior;
        return this;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

