// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ResourceType. */
public final class ResourceType extends ExpandableStringEnum<ResourceType> {
    /** Static value Microsoft.Cdn/Profiles/Endpoints for ResourceType. */
    public static final ResourceType MICROSOFT_CDN_PROFILES_ENDPOINTS = fromString("Microsoft.Cdn/Profiles/Endpoints");

    /** Static value Microsoft.Cdn/Profiles/AfdEndpoints for ResourceType. */
    public static final ResourceType MICROSOFT_CDN_PROFILES_AFD_ENDPOINTS =
        fromString("Microsoft.Cdn/Profiles/AfdEndpoints");

    /**
     * Creates or finds a ResourceType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ResourceType.
     */
    @JsonCreator
    public static ResourceType fromString(String name) {
        return fromString(name, ResourceType.class);
    }

    /** @return known ResourceType values. */
    public static Collection<ResourceType> values() {
        return values(ResourceType.class);
    }
}
