// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The JSON object containing endpoint update parameters. */
@Fluent
public class AfdEndpointPropertiesUpdateParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AfdEndpointPropertiesUpdateParameters.class);

    /*
     * The name of the profile which holds the endpoint.
     */
    @JsonProperty(value = "profileName", access = JsonProperty.Access.WRITE_ONLY)
    private String profileName;

    /*
     * Whether to enable use of this rule. Permitted values are 'Enabled' or
     * 'Disabled'
     */
    @JsonProperty(value = "enabledState")
    private EnabledState enabledState;

    /**
     * Get the profileName property: The name of the profile which holds the endpoint.
     *
     * @return the profileName value.
     */
    public String profileName() {
        return this.profileName;
    }

    /**
     * Get the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     *
     * @return the enabledState value.
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     *
     * @param enabledState the enabledState value to set.
     * @return the AfdEndpointPropertiesUpdateParameters object itself.
     */
    public AfdEndpointPropertiesUpdateParameters withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
