// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The JSON object containing endpoint update parameters. */
@Fluent
public class EndpointPropertiesUpdateParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EndpointPropertiesUpdateParameters.class);

    /*
     * A directory path on the origin that CDN can use to retrieve content
     * from, e.g. contoso.cloudapp.net/originpath.
     */
    @JsonProperty(value = "originPath")
    private String originPath;

    /*
     * List of content types on which compression applies. The value should be
     * a valid MIME type.
     */
    @JsonProperty(value = "contentTypesToCompress")
    private List<String> contentTypesToCompress;

    /*
     * The host header value sent to the origin with each request. This
     * property at Endpoint is only allowed when endpoint uses single origin
     * and can be overridden by the same property specified at origin.If you
     * leave this blank, the request hostname determines this value. Azure CDN
     * origins, such as Web Apps, Blob Storage, and Cloud Services require this
     * host header value to match the origin hostname by default.
     */
    @JsonProperty(value = "originHostHeader")
    private String originHostHeader;

    /*
     * Indicates whether content compression is enabled on CDN. Default value
     * is false. If compression is enabled, content will be served as
     * compressed if user requests for a compressed version. Content won't be
     * compressed on CDN when requested content is smaller than 1 byte or
     * larger than 1 MB.
     */
    @JsonProperty(value = "isCompressionEnabled")
    private Boolean isCompressionEnabled;

    /*
     * Indicates whether HTTP traffic is allowed on the endpoint. Default value
     * is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JsonProperty(value = "isHttpAllowed")
    private Boolean isHttpAllowed;

    /*
     * Indicates whether HTTPS traffic is allowed on the endpoint. Default
     * value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JsonProperty(value = "isHttpsAllowed")
    private Boolean isHttpsAllowed;

    /*
     * Defines how CDN caches requests that include query strings. You can
     * ignore any query strings when caching, bypass caching to prevent
     * requests that contain query strings from being cached, or cache every
     * request with a unique URL.
     */
    @JsonProperty(value = "queryStringCachingBehavior")
    private QueryStringCachingBehavior queryStringCachingBehavior;

    /*
     * Specifies what scenario the customer wants this CDN endpoint to optimize
     * for, e.g. Download, Media services. With this information, CDN can apply
     * scenario driven optimization.
     */
    @JsonProperty(value = "optimizationType")
    private OptimizationType optimizationType;

    /*
     * Path to a file hosted on the origin which helps accelerate delivery of
     * the dynamic content and calculate the most optimal routes for the CDN.
     * This is relative to the origin path. This property is only relevant when
     * using a single origin.
     */
    @JsonProperty(value = "probePath")
    private String probePath;

    /*
     * List of rules defining the user's geo access within a CDN endpoint. Each
     * geo filter defines an access rule to a specified path or content, e.g.
     * block APAC for path /pictures/
     */
    @JsonProperty(value = "geoFilters")
    private List<GeoFilter> geoFilters;

    /*
     * A reference to the origin group.
     */
    @JsonProperty(value = "defaultOriginGroup")
    private ResourceReference defaultOriginGroup;

    /*
     * List of keys used to validate the signed URL hashes.
     */
    @JsonProperty(value = "urlSigningKeys")
    private List<UrlSigningKey> urlSigningKeys;

    /*
     * A policy that specifies the delivery rules to be used for an endpoint.
     */
    @JsonProperty(value = "deliveryPolicy")
    private EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy;

    /*
     * Defines the Web Application Firewall policy for the endpoint (if
     * applicable)
     */
    @JsonProperty(value = "webApplicationFirewallPolicyLink")
    private EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink;

    /**
     * Get the originPath property: A directory path on the origin that CDN can use to retrieve content from, e.g.
     * contoso.cloudapp.net/originpath.
     *
     * @return the originPath value.
     */
    public String originPath() {
        return this.originPath;
    }

    /**
     * Set the originPath property: A directory path on the origin that CDN can use to retrieve content from, e.g.
     * contoso.cloudapp.net/originpath.
     *
     * @param originPath the originPath value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    /**
     * Get the contentTypesToCompress property: List of content types on which compression applies. The value should be
     * a valid MIME type.
     *
     * @return the contentTypesToCompress value.
     */
    public List<String> contentTypesToCompress() {
        return this.contentTypesToCompress;
    }

    /**
     * Set the contentTypesToCompress property: List of content types on which compression applies. The value should be
     * a valid MIME type.
     *
     * @param contentTypesToCompress the contentTypesToCompress value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withContentTypesToCompress(List<String> contentTypesToCompress) {
        this.contentTypesToCompress = contentTypesToCompress;
        return this;
    }

    /**
     * Get the originHostHeader property: The host header value sent to the origin with each request. This property at
     * Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at
     * origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps,
     * Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     *
     * @return the originHostHeader value.
     */
    public String originHostHeader() {
        return this.originHostHeader;
    }

    /**
     * Set the originHostHeader property: The host header value sent to the origin with each request. This property at
     * Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at
     * origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps,
     * Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     *
     * @param originHostHeader the originHostHeader value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    /**
     * Get the isCompressionEnabled property: Indicates whether content compression is enabled on CDN. Default value is
     * false. If compression is enabled, content will be served as compressed if user requests for a compressed version.
     * Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
     *
     * @return the isCompressionEnabled value.
     */
    public Boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    /**
     * Set the isCompressionEnabled property: Indicates whether content compression is enabled on CDN. Default value is
     * false. If compression is enabled, content will be served as compressed if user requests for a compressed version.
     * Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
     *
     * @param isCompressionEnabled the isCompressionEnabled value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withIsCompressionEnabled(Boolean isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    /**
     * Get the isHttpAllowed property: Indicates whether HTTP traffic is allowed on the endpoint. Default value is true.
     * At least one protocol (HTTP or HTTPS) must be allowed.
     *
     * @return the isHttpAllowed value.
     */
    public Boolean isHttpAllowed() {
        return this.isHttpAllowed;
    }

    /**
     * Set the isHttpAllowed property: Indicates whether HTTP traffic is allowed on the endpoint. Default value is true.
     * At least one protocol (HTTP or HTTPS) must be allowed.
     *
     * @param isHttpAllowed the isHttpAllowed value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withIsHttpAllowed(Boolean isHttpAllowed) {
        this.isHttpAllowed = isHttpAllowed;
        return this;
    }

    /**
     * Get the isHttpsAllowed property: Indicates whether HTTPS traffic is allowed on the endpoint. Default value is
     * true. At least one protocol (HTTP or HTTPS) must be allowed.
     *
     * @return the isHttpsAllowed value.
     */
    public Boolean isHttpsAllowed() {
        return this.isHttpsAllowed;
    }

    /**
     * Set the isHttpsAllowed property: Indicates whether HTTPS traffic is allowed on the endpoint. Default value is
     * true. At least one protocol (HTTP or HTTPS) must be allowed.
     *
     * @param isHttpsAllowed the isHttpsAllowed value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withIsHttpsAllowed(Boolean isHttpsAllowed) {
        this.isHttpsAllowed = isHttpsAllowed;
        return this;
    }

    /**
     * Get the queryStringCachingBehavior property: Defines how CDN caches requests that include query strings. You can
     * ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being
     * cached, or cache every request with a unique URL.
     *
     * @return the queryStringCachingBehavior value.
     */
    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    /**
     * Set the queryStringCachingBehavior property: Defines how CDN caches requests that include query strings. You can
     * ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being
     * cached, or cache every request with a unique URL.
     *
     * @param queryStringCachingBehavior the queryStringCachingBehavior value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withQueryStringCachingBehavior(
        QueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    /**
     * Get the optimizationType property: Specifies what scenario the customer wants this CDN endpoint to optimize for,
     * e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     *
     * @return the optimizationType value.
     */
    public OptimizationType optimizationType() {
        return this.optimizationType;
    }

    /**
     * Set the optimizationType property: Specifies what scenario the customer wants this CDN endpoint to optimize for,
     * e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     *
     * @param optimizationType the optimizationType value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withOptimizationType(OptimizationType optimizationType) {
        this.optimizationType = optimizationType;
        return this;
    }

    /**
     * Get the probePath property: Path to a file hosted on the origin which helps accelerate delivery of the dynamic
     * content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is
     * only relevant when using a single origin.
     *
     * @return the probePath value.
     */
    public String probePath() {
        return this.probePath;
    }

    /**
     * Set the probePath property: Path to a file hosted on the origin which helps accelerate delivery of the dynamic
     * content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is
     * only relevant when using a single origin.
     *
     * @param probePath the probePath value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withProbePath(String probePath) {
        this.probePath = probePath;
        return this;
    }

    /**
     * Get the geoFilters property: List of rules defining the user's geo access within a CDN endpoint. Each geo filter
     * defines an access rule to a specified path or content, e.g. block APAC for path /pictures/.
     *
     * @return the geoFilters value.
     */
    public List<GeoFilter> geoFilters() {
        return this.geoFilters;
    }

    /**
     * Set the geoFilters property: List of rules defining the user's geo access within a CDN endpoint. Each geo filter
     * defines an access rule to a specified path or content, e.g. block APAC for path /pictures/.
     *
     * @param geoFilters the geoFilters value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withGeoFilters(List<GeoFilter> geoFilters) {
        this.geoFilters = geoFilters;
        return this;
    }

    /**
     * Get the defaultOriginGroup property: A reference to the origin group.
     *
     * @return the defaultOriginGroup value.
     */
    public ResourceReference defaultOriginGroup() {
        return this.defaultOriginGroup;
    }

    /**
     * Set the defaultOriginGroup property: A reference to the origin group.
     *
     * @param defaultOriginGroup the defaultOriginGroup value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        this.defaultOriginGroup = defaultOriginGroup;
        return this;
    }

    /**
     * Get the urlSigningKeys property: List of keys used to validate the signed URL hashes.
     *
     * @return the urlSigningKeys value.
     */
    public List<UrlSigningKey> urlSigningKeys() {
        return this.urlSigningKeys;
    }

    /**
     * Set the urlSigningKeys property: List of keys used to validate the signed URL hashes.
     *
     * @param urlSigningKeys the urlSigningKeys value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        this.urlSigningKeys = urlSigningKeys;
        return this;
    }

    /**
     * Get the deliveryPolicy property: A policy that specifies the delivery rules to be used for an endpoint.
     *
     * @return the deliveryPolicy value.
     */
    public EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy() {
        return this.deliveryPolicy;
    }

    /**
     * Set the deliveryPolicy property: A policy that specifies the delivery rules to be used for an endpoint.
     *
     * @param deliveryPolicy the deliveryPolicy value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withDeliveryPolicy(
        EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        this.deliveryPolicy = deliveryPolicy;
        return this;
    }

    /**
     * Get the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for the endpoint
     * (if applicable).
     *
     * @return the webApplicationFirewallPolicyLink value.
     */
    public EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.webApplicationFirewallPolicyLink;
    }

    /**
     * Set the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for the endpoint
     * (if applicable).
     *
     * @param webApplicationFirewallPolicyLink the webApplicationFirewallPolicyLink value to set.
     * @return the EndpointPropertiesUpdateParameters object itself.
     */
    public EndpointPropertiesUpdateParameters withWebApplicationFirewallPolicyLink(
        EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        this.webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (geoFilters() != null) {
            geoFilters().forEach(e -> e.validate());
        }
        if (defaultOriginGroup() != null) {
            defaultOriginGroup().validate();
        }
        if (urlSigningKeys() != null) {
            urlSigningKeys().forEach(e -> e.validate());
        }
        if (deliveryPolicy() != null) {
            deliveryPolicy().validate();
        }
        if (webApplicationFirewallPolicyLink() != null) {
            webApplicationFirewallPolicyLink().validate();
        }
    }
}
