// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.PoliciesClient;
import com.azure.resourcemanager.cdn.fluent.models.CdnWebApplicationFirewallPolicyInner;
import com.azure.resourcemanager.cdn.models.CdnWebApplicationFirewallPolicyList;
import com.azure.resourcemanager.cdn.models.CdnWebApplicationFirewallPolicyPatchParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PoliciesClient. */
public final class PoliciesClientImpl
    implements InnerSupportsGet<CdnWebApplicationFirewallPolicyInner>, InnerSupportsDelete<Void>, PoliciesClient {
    private final ClientLogger logger = new ClientLogger(PoliciesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final PoliciesService service;

    /** The service client containing this operation class. */
    private final CdnManagementClientImpl client;

    /**
     * Initializes an instance of PoliciesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    PoliciesClientImpl(CdnManagementClientImpl client) {
        this.service = RestProxy.create(PoliciesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CdnManagementClientPolicies to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CdnManagementClientP")
    private interface PoliciesService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn"
                + "/cdnWebApplicationFirewallPolicies")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CdnWebApplicationFirewallPolicyList>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn"
                + "/cdnWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CdnWebApplicationFirewallPolicyInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("policyName") String policyName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn"
                + "/cdnWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("policyName") String policyName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn"
                + "/cdnWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("policyName") String policyName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json")
                CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn"
                + "/cdnWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("policyName") String policyName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CdnWebApplicationFirewallPolicyList>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<CdnWebApplicationFirewallPolicyInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CdnWebApplicationFirewallPolicyInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CdnWebApplicationFirewallPolicyInner> listByResourceGroupAsync(
        String resourceGroupName, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CdnWebApplicationFirewallPolicyInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CdnWebApplicationFirewallPolicyInner> listByResourceGroup(
        String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CdnWebApplicationFirewallPolicyInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String policyName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            policyName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CdnWebApplicationFirewallPolicyInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String policyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                policyName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CdnWebApplicationFirewallPolicyInner> getByResourceGroupAsync(
        String resourceGroupName, String policyName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, policyName)
            .flatMap(
                (Response<CdnWebApplicationFirewallPolicyInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CdnWebApplicationFirewallPolicyInner getByResourceGroup(String resourceGroupName, String policyName) {
        return getByResourceGroupAsync(resourceGroupName, policyName).block();
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CdnWebApplicationFirewallPolicyInner> getByResourceGroupWithResponse(
        String resourceGroupName, String policyName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, policyName, context).block();
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cdnWebApplicationFirewallPolicy == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter cdnWebApplicationFirewallPolicy is required and cannot be null."));
        } else {
            cdnWebApplicationFirewallPolicy.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            policyName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            cdnWebApplicationFirewallPolicy,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cdnWebApplicationFirewallPolicy == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter cdnWebApplicationFirewallPolicy is required and cannot be null."));
        } else {
            cdnWebApplicationFirewallPolicy.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                policyName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                cdnWebApplicationFirewallPolicy,
                accept,
                context);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy);
        return this
            .client
            .<CdnWebApplicationFirewallPolicyInner, CdnWebApplicationFirewallPolicyInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CdnWebApplicationFirewallPolicyInner.class,
                CdnWebApplicationFirewallPolicyInner.class,
                this.client.getContext());
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy, context);
        return this
            .client
            .<CdnWebApplicationFirewallPolicyInner, CdnWebApplicationFirewallPolicyInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CdnWebApplicationFirewallPolicyInner.class,
                CdnWebApplicationFirewallPolicyInner.class,
                context);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return beginCreateOrUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).getSyncPoller();
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy,
            Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy, context)
            .getSyncPoller();
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CdnWebApplicationFirewallPolicyInner> createOrUpdateAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return beginCreateOrUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CdnWebApplicationFirewallPolicyInner> createOrUpdateAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CdnWebApplicationFirewallPolicyInner createOrUpdate(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return createOrUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).block();
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CdnWebApplicationFirewallPolicyInner createOrUpdate(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy, context).block();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cdnWebApplicationFirewallPolicyPatchParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter cdnWebApplicationFirewallPolicyPatchParameters is required and cannot be null."));
        } else {
            cdnWebApplicationFirewallPolicyPatchParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            policyName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            cdnWebApplicationFirewallPolicyPatchParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cdnWebApplicationFirewallPolicyPatchParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter cdnWebApplicationFirewallPolicyPatchParameters is required and cannot be null."));
        } else {
            cdnWebApplicationFirewallPolicyPatchParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                policyName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                cdnWebApplicationFirewallPolicyPatchParameters,
                accept,
                context);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginUpdateAsync(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters);
        return this
            .client
            .<CdnWebApplicationFirewallPolicyInner, CdnWebApplicationFirewallPolicyInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CdnWebApplicationFirewallPolicyInner.class,
                CdnWebApplicationFirewallPolicyInner.class,
                this.client.getContext());
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginUpdateAsync(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters, context);
        return this
            .client
            .<CdnWebApplicationFirewallPolicyInner, CdnWebApplicationFirewallPolicyInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                CdnWebApplicationFirewallPolicyInner.class,
                CdnWebApplicationFirewallPolicyInner.class,
                context);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginUpdate(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters) {
        return beginUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters)
            .getSyncPoller();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>
        beginUpdate(
            String resourceGroupName,
            String policyName,
            CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters,
            Context context) {
        return beginUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters, context)
            .getSyncPoller();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CdnWebApplicationFirewallPolicyInner> updateAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters) {
        return beginUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CdnWebApplicationFirewallPolicyInner> updateAsync(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters,
        Context context) {
        return beginUpdateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CdnWebApplicationFirewallPolicyInner update(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters) {
        return updateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters).block();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified
     * subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicyPatchParameters CdnWebApplicationFirewallPolicy parameters to be patched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines web application firewall policy for Azure CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CdnWebApplicationFirewallPolicyInner update(
        String resourceGroupName,
        String policyName,
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters,
        Context context) {
        return updateAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicyPatchParameters, context)
            .block();
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String policyName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            policyName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String policyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                policyName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String policyName) {
        return deleteWithResponseAsync(resourceGroupName, policyName).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String policyName) {
        deleteAsync(resourceGroupName, policyName).block();
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String policyName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, policyName, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CdnWebApplicationFirewallPolicyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<CdnWebApplicationFirewallPolicyInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines a list of WebApplicationFirewallPolicies for Azure CDN along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CdnWebApplicationFirewallPolicyInner>> listNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
