// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SecurityPolicyType. */
public final class SecurityPolicyType extends ExpandableStringEnum<SecurityPolicyType> {
    /** Static value WebApplicationFirewall for SecurityPolicyType. */
    public static final SecurityPolicyType WEB_APPLICATION_FIREWALL = fromString("WebApplicationFirewall");

    /**
     * Creates or finds a SecurityPolicyType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SecurityPolicyType.
     */
    @JsonCreator
    public static SecurityPolicyType fromString(String name) {
        return fromString(name, SecurityPolicyType.class);
    }

    /** @return known SecurityPolicyType values. */
    public static Collection<SecurityPolicyType> values() {
        return values(SecurityPolicyType.class);
    }
}
