/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.Certificate;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecretType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CustomerCertificate
extends Certificate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CustomerCertificate.class);
    @JsonProperty(value="secretSource")
    private ResourceReference secretSource;
    @JsonProperty(value="secretVersion")
    private String secretVersion;
    @JsonProperty(value="certificateAuthority", access=JsonProperty.Access.WRITE_ONLY)
    private String certificateAuthority;
    @JsonProperty(value="useLatestVersion")
    private Boolean useLatestVersion;
    @JsonProperty(value="subjectAlternativeNames")
    private List<String> subjectAlternativeNames;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public CustomerCertificate withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public CustomerCertificate withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    public CustomerCertificate withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CustomerCertificate withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    @Override
    public CustomerCertificate withType(SecretType type) {
        super.withType(type);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.secretSource() != null) {
            this.secretSource().validate();
        }
    }
}

