/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginProperties;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AfdOriginInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AfdOriginInner.class);
    @JsonProperty(value="properties")
    private AfdOriginProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private AfdOriginProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    public String originGroupName() {
        return this.innerProperties() == null ? null : this.innerProperties().originGroupName();
    }

    public ResourceReference azureOrigin() {
        return this.innerProperties() == null ? null : this.innerProperties().azureOrigin();
    }

    public AfdOriginInner withAzureOrigin(ResourceReference azureOrigin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withAzureOrigin(azureOrigin);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public AfdOriginInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    public Integer httpPort() {
        return this.innerProperties() == null ? null : this.innerProperties().httpPort();
    }

    public AfdOriginInner withHttpPort(Integer httpPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withHttpPort(httpPort);
        return this;
    }

    public Integer httpsPort() {
        return this.innerProperties() == null ? null : this.innerProperties().httpsPort();
    }

    public AfdOriginInner withHttpsPort(Integer httpsPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withHttpsPort(httpsPort);
        return this;
    }

    public String originHostHeader() {
        return this.innerProperties() == null ? null : this.innerProperties().originHostHeader();
    }

    public AfdOriginInner withOriginHostHeader(String originHostHeader) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withOriginHostHeader(originHostHeader);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public AfdOriginInner withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public Integer weight() {
        return this.innerProperties() == null ? null : this.innerProperties().weight();
    }

    public AfdOriginInner withWeight(Integer weight) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withWeight(weight);
        return this;
    }

    public Object sharedPrivateLinkResource() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedPrivateLinkResource();
    }

    public AfdOriginInner withSharedPrivateLinkResource(Object sharedPrivateLinkResource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withSharedPrivateLinkResource(sharedPrivateLinkResource);
        return this;
    }

    public EnabledState enabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledState();
    }

    public AfdOriginInner withEnabledState(EnabledState enabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withEnabledState(enabledState);
        return this;
    }

    public Boolean enforceCertificateNameCheck() {
        return this.innerProperties() == null ? null : this.innerProperties().enforceCertificateNameCheck();
    }

    public AfdOriginInner withEnforceCertificateNameCheck(Boolean enforceCertificateNameCheck) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginProperties();
        }
        this.innerProperties().withEnforceCertificateNameCheck(enforceCertificateNameCheck);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

