/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DeepCreatedOriginGroupProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DeepCreatedOriginGroupProperties.class);
    @JsonProperty(value="healthProbeSettings")
    private HealthProbeParameters healthProbeSettings;
    @JsonProperty(value="origins", required=true)
    private List<ResourceReference> origins;
    @JsonProperty(value="trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    @JsonProperty(value="responseBasedOriginErrorDetectionSettings")
    private ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings;

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public DeepCreatedOriginGroupProperties withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public List<ResourceReference> origins() {
        return this.origins;
    }

    public DeepCreatedOriginGroupProperties withOrigins(List<ResourceReference> origins) {
        this.origins = origins;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public DeepCreatedOriginGroupProperties withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.responseBasedOriginErrorDetectionSettings;
    }

    public DeepCreatedOriginGroupProperties withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        this.responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings;
        return this;
    }

    public void validate() {
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.origins() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property origins in model DeepCreatedOriginGroupProperties"));
        }
        this.origins().forEach(e -> e.validate());
        if (this.responseBasedOriginErrorDetectionSettings() != null) {
            this.responseBasedOriginErrorDetectionSettings().validate();
        }
    }
}

