/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainInner;
import com.azure.resourcemanager.cdn.fluent.models.EndpointProperties;
import com.azure.resourcemanager.cdn.models.DeepCreatedOrigin;
import com.azure.resourcemanager.cdn.models.DeepCreatedOriginGroup;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.EndpointResourceState;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class EndpointInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EndpointInner.class);
    @JsonProperty(value="properties")
    private EndpointProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private EndpointProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public EndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public EndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public List<DeepCreatedOrigin> origins() {
        return this.innerProperties() == null ? null : this.innerProperties().origins();
    }

    public EndpointInner withOrigins(List<DeepCreatedOrigin> origins) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withOrigins(origins);
        return this;
    }

    public List<DeepCreatedOriginGroup> originGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().originGroups();
    }

    public EndpointInner withOriginGroups(List<DeepCreatedOriginGroup> originGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withOriginGroups(originGroups);
        return this;
    }

    public List<CustomDomainInner> customDomains() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomains();
    }

    public EndpointResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String originPath() {
        return this.innerProperties() == null ? null : this.innerProperties().originPath();
    }

    public EndpointInner withOriginPath(String originPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withOriginPath(originPath);
        return this;
    }

    public List<String> contentTypesToCompress() {
        return this.innerProperties() == null ? null : this.innerProperties().contentTypesToCompress();
    }

    public EndpointInner withContentTypesToCompress(List<String> contentTypesToCompress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withContentTypesToCompress((List)contentTypesToCompress);
        return this;
    }

    public String originHostHeader() {
        return this.innerProperties() == null ? null : this.innerProperties().originHostHeader();
    }

    public EndpointInner withOriginHostHeader(String originHostHeader) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withOriginHostHeader(originHostHeader);
        return this;
    }

    public Boolean isCompressionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isCompressionEnabled();
    }

    public EndpointInner withIsCompressionEnabled(Boolean isCompressionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withIsCompressionEnabled(isCompressionEnabled);
        return this;
    }

    public Boolean isHttpAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isHttpAllowed();
    }

    public EndpointInner withIsHttpAllowed(Boolean isHttpAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withIsHttpAllowed(isHttpAllowed);
        return this;
    }

    public Boolean isHttpsAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isHttpsAllowed();
    }

    public EndpointInner withIsHttpsAllowed(Boolean isHttpsAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withIsHttpsAllowed(isHttpsAllowed);
        return this;
    }

    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.innerProperties() == null ? null : this.innerProperties().queryStringCachingBehavior();
    }

    public EndpointInner withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withQueryStringCachingBehavior(queryStringCachingBehavior);
        return this;
    }

    public OptimizationType optimizationType() {
        return this.innerProperties() == null ? null : this.innerProperties().optimizationType();
    }

    public EndpointInner withOptimizationType(OptimizationType optimizationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withOptimizationType(optimizationType);
        return this;
    }

    public String probePath() {
        return this.innerProperties() == null ? null : this.innerProperties().probePath();
    }

    public EndpointInner withProbePath(String probePath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withProbePath(probePath);
        return this;
    }

    public List<GeoFilter> geoFilters() {
        return this.innerProperties() == null ? null : this.innerProperties().geoFilters();
    }

    public EndpointInner withGeoFilters(List<GeoFilter> geoFilters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withGeoFilters((List)geoFilters);
        return this;
    }

    public ResourceReference defaultOriginGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultOriginGroup();
    }

    public EndpointInner withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withDefaultOriginGroup(defaultOriginGroup);
        return this;
    }

    public List<UrlSigningKey> urlSigningKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().urlSigningKeys();
    }

    public EndpointInner withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withUrlSigningKeys((List)urlSigningKeys);
        return this;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryPolicy();
    }

    public EndpointInner withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withDeliveryPolicy(deliveryPolicy);
        return this;
    }

    public EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.innerProperties() == null ? null : this.innerProperties().webApplicationFirewallPolicyLink();
    }

    public EndpointInner withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

