/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.ProfileProperties;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ProfileInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProfileInner.class);
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="properties")
    private ProfileProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public Sku sku() {
        return this.sku;
    }

    public ProfileInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    private ProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProfileResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public ManagedServiceIdentity identity() {
        return this.innerProperties() == null ? null : this.innerProperties().identity();
    }

    public ProfileInner withIdentity(ManagedServiceIdentity identity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfileProperties();
        }
        this.innerProperties().withIdentity(identity);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String frontDoorId() {
        return this.innerProperties() == null ? null : this.innerProperties().frontDoorId();
    }

    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    public ProfileInner withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfileProperties();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model ProfileInner"));
        }
        this.sku().validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

