/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.ValidatesClient;
import com.azure.resourcemanager.cdn.fluent.models.ValidateSecretOutputInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.ValidateSecretInput;
import reactor.core.publisher.Mono;

public final class ValidatesClientImpl
implements ValidatesClient {
    private final ClientLogger logger = new ClientLogger(ValidatesClientImpl.class);
    private final ValidatesService service;
    private final CdnManagementClientImpl client;

    ValidatesClientImpl(CdnManagementClientImpl client) {
        this.service = (ValidatesService)RestProxy.create(ValidatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ValidateSecretOutputInner>> secretWithResponseAsync(ValidateSecretInput validateSecretInput) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (validateSecretInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validateSecretInput is required and cannot be null."));
        }
        validateSecretInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.secret(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), validateSecretInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidateSecretOutputInner>> secretWithResponseAsync(ValidateSecretInput validateSecretInput, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (validateSecretInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validateSecretInput is required and cannot be null."));
        }
        validateSecretInput.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.secret(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), validateSecretInput, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ValidateSecretOutputInner> secretAsync(ValidateSecretInput validateSecretInput) {
        return this.secretWithResponseAsync(validateSecretInput).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidateSecretOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidateSecretOutputInner secret(ValidateSecretInput validateSecretInput) {
        return (ValidateSecretOutputInner)this.secretAsync(validateSecretInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidateSecretOutputInner> secretWithResponse(ValidateSecretInput validateSecretInput, Context context) {
        return (Response)this.secretWithResponseAsync(validateSecretInput, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientV")
    private static interface ValidatesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateSecret")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateSecretOutputInner>> secret(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ValidateSecretInput var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

